/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.web.advice.JsonFilterFields;
import br.com.elotech.di.domain.Grupo;
import br.com.elotech.di.domain.Modulo;
import br.com.elotech.di.domain.Usuario;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="unico.recurso")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@JsonFilterFields(of={"id", "nome", "descricao", "modulo.id", "modulo.descricao", "funcionalidade", "grupos.id", "grupos.nome", "usuarios.id", "usuarios.usuario"})
public class Recurso
implements EloEntity<Long> {
    @EloSequence
    @Id
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotEmpty
    @Caption(value="Nome")
    @Column(length=50)
    private String nome;
    @NotEmpty
    @Caption(value="Descri\u00e7\u00e3o")
    @Column(length=50)
    private String descricao;
    @NotNull
    @ManyToOne
    private Modulo modulo;
    @Caption(value="Funcionalidade")
    @Column(length=60)
    private String funcionalidade;
    @OneToMany
    @JoinTable(name="unico.gruporecurso", joinColumns={@JoinColumn(name="recurso", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="grupo", referencedColumnName="id")})
    @Valid
    @Caption(value="Recursos")
    private final Set<Grupo> grupos = new HashSet();
    @OneToMany
    @JoinTable(name="unico.usuariorecurso", joinColumns={@JoinColumn(name="recurso", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="usuario", referencedColumnName="id")})
    private final Set<Usuario> usuarios = new HashSet();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Modulo getModulo() {
        return this.modulo;
    }

    public void setModulo(Modulo modulo) {
        this.modulo = modulo;
    }

    public static Recurso of(Long id) {
        return new Recurso().withId(id);
    }

    public Recurso withId(Long id) {
        this.setId(id);
        return this;
    }

    public Recurso withNome(String nome) {
        this.setNome(nome);
        return this;
    }

    public Recurso withDescricao(String descricao) {
        this.setDescricao(descricao);
        return this;
    }

    public Recurso withModulo(Modulo modulo) {
        this.setModulo(modulo);
        return this;
    }

    public String getFuncionalidade() {
        return this.funcionalidade;
    }

    public void setFuncionalidade(String funcionalidade) {
        this.funcionalidade = funcionalidade;
    }

    public Recurso withFuncionalidade(String value) {
        this.funcionalidade = value;
        return this;
    }

    public Set<Grupo> getGrupos() {
        return this.grupos;
    }

    public Set<Usuario> getUsuarios() {
        return this.usuarios;
    }

    @Generated
    public String toString() {
        return "Recurso(id=" + this.getId() + ", nome=" + this.getNome() + ", descricao=" + this.getDescricao() + ", modulo=" + String.valueOf(this.getModulo()) + ", funcionalidade=" + this.getFuncionalidade() + ", grupos=" + String.valueOf(this.getGrupos()) + ", usuarios=" + String.valueOf(this.getUsuarios()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Recurso)) {
            return false;
        }
        Recurso other = (Recurso)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Recurso;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

