/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.core.metamodel.annotation.ToModel;
import br.com.elotech.di.converter.StatusOcorrenciaConverter;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.StatusOcorrencia;
import br.com.elotech.di.domain.TipoOcorrencia;
import br.com.elotech.di.domain.shared.Arquivo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.pessoaocorrencia")
@DynamicUpdate
@DynamicInsert
@Audited
public class PessoaOcorrencia
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true)
    @Caption(value="C\u00f3digo")
    private Long id;
    @MetaModelIgnore
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @ToModel(of={"id", "nome", "tipoPessoa", "cnpjCpf"})
    @JoinColumn(name="pessoa_id")
    private Pessoa pessoa;
    @NotNull
    @Caption(value="Sequ\u00eancia")
    private Long sequencia;
    @NotNull
    @Caption(value="Data")
    private LocalDate data;
    @Caption(value="Data Publica\u00e7\u00e3o")
    @Column(name="datapublicacao")
    private LocalDate dataPublicacao;
    @Caption(value="Tipo")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tipoocorrencia_id")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private TipoOcorrencia tipo;
    @Length(max=4000)
    private @Length(max=4000) String fundamento;
    @NotNull
    @Caption(value="Status")
    @Convert(converter=StatusOcorrenciaConverter.class)
    private StatusOcorrencia status = StatusOcorrencia.CONFIRMADO;
    @Length(max=4000)
    private @Length(max=4000) String observacao;
    @Caption(value="Data Restri\u00e7\u00e3o Inicial")
    @Column(name="datarestricaoini")
    private LocalDate dataRestricaoInicio;
    @Caption(value="Data Restri\u00e7\u00e3o Final")
    @Column(name="datarestricaofim")
    private LocalDate dataRestricaoFim;
    @Valid
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="arquivo_id")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="")
    private Arquivo arquivo;

    @Generated
    public String toString() {
        return "PessoaOcorrencia(id=" + this.getId() + ", pessoa=" + String.valueOf(this.getPessoa()) + ", sequencia=" + this.getSequencia() + ", data=" + String.valueOf(this.getData()) + ", dataPublicacao=" + String.valueOf(this.getDataPublicacao()) + ", tipo=" + String.valueOf(this.getTipo()) + ", fundamento=" + this.getFundamento() + ", status=" + String.valueOf(this.getStatus()) + ", observacao=" + this.getObservacao() + ", dataRestricaoInicio=" + String.valueOf(this.getDataRestricaoInicio()) + ", dataRestricaoFim=" + String.valueOf(this.getDataRestricaoFim()) + ", arquivo=" + String.valueOf(this.getArquivo()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PessoaOcorrencia)) {
            return false;
        }
        PessoaOcorrencia other = (PessoaOcorrencia)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PessoaOcorrencia;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public LocalDate getDataPublicacao() {
        return this.dataPublicacao;
    }

    @Generated
    public TipoOcorrencia getTipo() {
        return this.tipo;
    }

    @Generated
    public String getFundamento() {
        return this.fundamento;
    }

    @Generated
    public StatusOcorrencia getStatus() {
        return this.status;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public LocalDate getDataRestricaoInicio() {
        return this.dataRestricaoInicio;
    }

    @Generated
    public LocalDate getDataRestricaoFim() {
        return this.dataRestricaoFim;
    }

    @Generated
    public Arquivo getArquivo() {
        return this.arquivo;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setDataPublicacao(LocalDate dataPublicacao) {
        this.dataPublicacao = dataPublicacao;
    }

    @Generated
    public void setTipo(TipoOcorrencia tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setFundamento(String fundamento) {
        this.fundamento = fundamento;
    }

    @Generated
    public void setStatus(StatusOcorrencia status) {
        this.status = status;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setDataRestricaoInicio(LocalDate dataRestricaoInicio) {
        this.dataRestricaoInicio = dataRestricaoInicio;
    }

    @Generated
    public void setDataRestricaoFim(LocalDate dataRestricaoFim) {
        this.dataRestricaoFim = dataRestricaoFim;
    }

    @Generated
    public void setArquivo(Arquivo arquivo) {
        this.arquivo = arquivo;
    }
}

