/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.shared.ArquivoContent;
import java.util.Base64;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;

@Entity
@Table(name="unico.pessoaimagem")
@DynamicInsert
@DynamicUpdate
@Audited
public class PessoaImagem
implements EloEntity<Long> {
    @Id
    @Caption(value="C\u00f3digo")
    @EloSequence(applyOnMerge=true)
    private Long id;
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;
    @Valid
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="idarquivo")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private Arquivo arquivo = new Arquivo();
    @Transient
    private String imagem;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Arquivo getArquivo() {
        return this.arquivo;
    }

    public void setArquivo(Arquivo arquivo) {
        this.arquivo = arquivo;
    }

    public Boolean getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    public static PessoaImagem of(Arquivo arquivo) {
        PessoaImagem pessoaImagem = new PessoaImagem();
        pessoaImagem.setArquivo(arquivo);
        return pessoaImagem;
    }

    public String getImagem() {
        return Optional.ofNullable(this.arquivo).map(Arquivo::getContent).map(ArquivoContent::getBinary).map(binary -> {
            String imagemString = Base64.getEncoder().encodeToString((byte[])binary);
            return String.format("data:image/%s;base64,%s", this.arquivo.getMimeType(), imagemString);
        }).orElse("");
    }

    @Generated
    public String toString() {
        return "PessoaImagem(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PessoaImagem)) {
            return false;
        }
        PessoaImagem other = (PessoaImagem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PessoaImagem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public PessoaImagem() {
    }

    @Generated
    public void setImagem(String imagem) {
        this.imagem = imagem;
    }
}

