/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.json.EloFilterable;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.Documento;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.validation.SkipBatch;
import java.time.LocalDate;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Formula;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.validator.constraints.Length;

@Embeddable
public class PessoaDoc
implements EloFilterable {
    @Id
    private Long id;
    @ManyToOne
    @Caption(value="Documento")
    @NotNull(groups={SkipBatch.class})
    private Documento documento;
    @Caption(value="N\u00famero Documento")
    @Length(max=50)
    @NotNull
    private @Length(max=50) @NotNull String numeroDocumento;
    @Valid
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="idarquivo")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="")
    private Arquivo arquivo;
    @Caption(value="Data Emiss\u00e3o")
    @NotNull
    private LocalDate dataEmissao;
    @Caption(value="Data Altera\u00e7\u00e3o")
    private LocalDate dataAlteracao = LocalDate.now();
    @Caption(value="Data Validade")
    private LocalDate dataValidade;
    @NotAudited
    @Formula(value="(select coalesce(u.nome, 'Usu\u00e1rio Importa\u00e7\u00e3o') from {SCHEMA_UNICO}.documentopessoa_aud d                          inner join {SCHEMA_UNICO}.revision r on d.rev = r.revisionnumber                          left join {SCHEMA_UNICO}.usuario u on r.username = u.usuario                          where d.numerodocumento = numeroDocumento and d.revtype = 0 and d.id = id)")
    private String nomeUsuarioDocumento;
    @NotAudited
    @Formula(value="(select r.username from {SCHEMA_UNICO}.documentopessoa_aud d                          inner join {SCHEMA_UNICO}.revision r on d.rev = r.revisionnumber                          where d.numerodocumento = numeroDocumento and d.revtype = 0 and d.id = id)")
    private String usuarioDocumento;

    public Documento getDocumento() {
        return this.documento;
    }

    public void setDocumento(Documento documento) {
        this.documento = documento;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public LocalDate getDataValidade() {
        return this.dataValidade;
    }

    public void setDataValidade(LocalDate dataValidade) {
        this.dataValidade = dataValidade;
    }

    public Arquivo getArquivo() {
        return this.arquivo;
    }

    public void setArquivo(Arquivo arquivo) {
        this.arquivo = arquivo;
    }

    public String getNomeUsuarioDocumento() {
        return this.nomeUsuarioDocumento;
    }

    public void setNomeUsuarioDocumento(String nomeUsuarioDocumento) {
        this.nomeUsuarioDocumento = nomeUsuarioDocumento;
    }

    public String getUsuarioDocumento() {
        return this.usuarioDocumento;
    }

    public void setUsuarioDocumento(String usuarioDocumento) {
        this.usuarioDocumento = usuarioDocumento;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PessoaDoc)) {
            return false;
        }
        PessoaDoc other = (PessoaDoc)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Documento this$documento = this.getDocumento();
        Documento other$documento = other.getDocumento();
        if (this$documento == null ? other$documento != null : !this$documento.equals(other$documento)) {
            return false;
        }
        String this$numeroDocumento = this.getNumeroDocumento();
        String other$numeroDocumento = other.getNumeroDocumento();
        if (this$numeroDocumento == null ? other$numeroDocumento != null : !this$numeroDocumento.equals(other$numeroDocumento)) {
            return false;
        }
        Arquivo this$arquivo = this.getArquivo();
        Arquivo other$arquivo = other.getArquivo();
        if (this$arquivo == null ? other$arquivo != null : !this$arquivo.equals(other$arquivo)) {
            return false;
        }
        LocalDate this$dataEmissao = this.getDataEmissao();
        LocalDate other$dataEmissao = other.getDataEmissao();
        if (this$dataEmissao == null ? other$dataEmissao != null : !((Object)this$dataEmissao).equals(other$dataEmissao)) {
            return false;
        }
        LocalDate this$dataAlteracao = this.getDataAlteracao();
        LocalDate other$dataAlteracao = other.getDataAlteracao();
        if (this$dataAlteracao == null ? other$dataAlteracao != null : !((Object)this$dataAlteracao).equals(other$dataAlteracao)) {
            return false;
        }
        LocalDate this$dataValidade = this.getDataValidade();
        LocalDate other$dataValidade = other.getDataValidade();
        if (this$dataValidade == null ? other$dataValidade != null : !((Object)this$dataValidade).equals(other$dataValidade)) {
            return false;
        }
        String this$nomeUsuarioDocumento = this.getNomeUsuarioDocumento();
        String other$nomeUsuarioDocumento = other.getNomeUsuarioDocumento();
        if (this$nomeUsuarioDocumento == null ? other$nomeUsuarioDocumento != null : !this$nomeUsuarioDocumento.equals(other$nomeUsuarioDocumento)) {
            return false;
        }
        String this$usuarioDocumento = this.getUsuarioDocumento();
        String other$usuarioDocumento = other.getUsuarioDocumento();
        return !(this$usuarioDocumento == null ? other$usuarioDocumento != null : !this$usuarioDocumento.equals(other$usuarioDocumento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PessoaDoc;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Documento $documento = this.getDocumento();
        result = result * 59 + ($documento == null ? 43 : $documento.hashCode());
        String $numeroDocumento = this.getNumeroDocumento();
        result = result * 59 + ($numeroDocumento == null ? 43 : $numeroDocumento.hashCode());
        Arquivo $arquivo = this.getArquivo();
        result = result * 59 + ($arquivo == null ? 43 : $arquivo.hashCode());
        LocalDate $dataEmissao = this.getDataEmissao();
        result = result * 59 + ($dataEmissao == null ? 43 : ((Object)$dataEmissao).hashCode());
        LocalDate $dataAlteracao = this.getDataAlteracao();
        result = result * 59 + ($dataAlteracao == null ? 43 : ((Object)$dataAlteracao).hashCode());
        LocalDate $dataValidade = this.getDataValidade();
        result = result * 59 + ($dataValidade == null ? 43 : ((Object)$dataValidade).hashCode());
        String $nomeUsuarioDocumento = this.getNomeUsuarioDocumento();
        result = result * 59 + ($nomeUsuarioDocumento == null ? 43 : $nomeUsuarioDocumento.hashCode());
        String $usuarioDocumento = this.getUsuarioDocumento();
        result = result * 59 + ($usuarioDocumento == null ? 43 : $usuarioDocumento.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PessoaDoc(id=" + this.getId() + ", documento=" + String.valueOf(this.getDocumento()) + ", numeroDocumento=" + this.getNumeroDocumento() + ", arquivo=" + String.valueOf(this.getArquivo()) + ", dataEmissao=" + String.valueOf(this.getDataEmissao()) + ", dataAlteracao=" + String.valueOf(this.getDataAlteracao()) + ", dataValidade=" + String.valueOf(this.getDataValidade()) + ", nomeUsuarioDocumento=" + this.getNomeUsuarioDocumento() + ", usuarioDocumento=" + this.getUsuarioDocumento() + ")";
    }
}

