/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.json.EloFilterable;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.Agencia;
import br.com.elotech.di.domain.TipoConta;
import br.com.elotech.di.validation.SkipBatch;
import java.time.LocalDate;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Embeddable
public class PessoaConta
implements EloFilterable {
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;
    @ManyToOne
    @Caption(value="Agencia")
    private Agencia agencia;
    @Caption(value="Conta")
    @Length(max=25)
    @NotBlank(groups={SkipBatch.class})
    private @Length(max=25) @NotBlank(groups={SkipBatch.class}) String conta;
    @Caption(value="Tipo Conta")
    @Column(length=1)
    private TipoConta tipoConta = TipoConta.CONTA_CORRENTE;
    @Caption(value="Ordem Bancaria")
    @Length(max=20)
    private @Length(max=20) String ordemBancaria;
    @Caption(value="Opera\u00e7\u00e3o")
    @Length(max=10)
    private @Length(max=10) String operacao;
    @Caption(value="Data Abertura")
    private LocalDate dataAbertura;
    @Caption(value="Data Encerramento")
    private LocalDate dataEncerramento;

    public Boolean getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    public Agencia getAgencia() {
        return this.agencia;
    }

    public void setAgencia(Agencia agencia) {
        this.agencia = agencia;
    }

    public String getConta() {
        return this.conta;
    }

    public void setConta(String conta) {
        this.conta = conta;
    }

    public TipoConta getTipoConta() {
        return this.tipoConta;
    }

    public void setTipoConta(TipoConta tipoConta) {
        this.tipoConta = tipoConta;
    }

    public String getOrdemBancaria() {
        return this.ordemBancaria;
    }

    public void setOrdemBancaria(String ordemBancaria) {
        this.ordemBancaria = ordemBancaria;
    }

    public String getOperacao() {
        return this.operacao;
    }

    public void setOperacao(String operacao) {
        this.operacao = operacao;
    }

    public LocalDate getDataAbertura() {
        return this.dataAbertura;
    }

    public void setDataAbertura(LocalDate dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    public LocalDate getDataEncerramento() {
        return this.dataEncerramento;
    }

    public void setDataEncerramento(LocalDate dataEncerramento) {
        this.dataEncerramento = dataEncerramento;
    }

    public Boolean hasDigito() {
        return Optional.ofNullable(this.conta).map(conta -> conta.contains("-")).orElse(false);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PessoaConta)) {
            return false;
        }
        PessoaConta other = (PessoaConta)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$principal = this.getPrincipal();
        Boolean other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !((Object)this$principal).equals(other$principal)) {
            return false;
        }
        Agencia this$agencia = this.getAgencia();
        Agencia other$agencia = other.getAgencia();
        if (this$agencia == null ? other$agencia != null : !this$agencia.equals(other$agencia)) {
            return false;
        }
        String this$conta = this.getConta();
        String other$conta = other.getConta();
        if (this$conta == null ? other$conta != null : !this$conta.equals(other$conta)) {
            return false;
        }
        TipoConta this$tipoConta = this.getTipoConta();
        TipoConta other$tipoConta = other.getTipoConta();
        if (this$tipoConta == null ? other$tipoConta != null : !this$tipoConta.equals(other$tipoConta)) {
            return false;
        }
        String this$ordemBancaria = this.getOrdemBancaria();
        String other$ordemBancaria = other.getOrdemBancaria();
        if (this$ordemBancaria == null ? other$ordemBancaria != null : !this$ordemBancaria.equals(other$ordemBancaria)) {
            return false;
        }
        String this$operacao = this.getOperacao();
        String other$operacao = other.getOperacao();
        if (this$operacao == null ? other$operacao != null : !this$operacao.equals(other$operacao)) {
            return false;
        }
        LocalDate this$dataAbertura = this.getDataAbertura();
        LocalDate other$dataAbertura = other.getDataAbertura();
        if (this$dataAbertura == null ? other$dataAbertura != null : !((Object)this$dataAbertura).equals(other$dataAbertura)) {
            return false;
        }
        LocalDate this$dataEncerramento = this.getDataEncerramento();
        LocalDate other$dataEncerramento = other.getDataEncerramento();
        return !(this$dataEncerramento == null ? other$dataEncerramento != null : !((Object)this$dataEncerramento).equals(other$dataEncerramento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PessoaConta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : ((Object)$principal).hashCode());
        Agencia $agencia = this.getAgencia();
        result = result * 59 + ($agencia == null ? 43 : $agencia.hashCode());
        String $conta = this.getConta();
        result = result * 59 + ($conta == null ? 43 : $conta.hashCode());
        TipoConta $tipoConta = this.getTipoConta();
        result = result * 59 + ($tipoConta == null ? 43 : $tipoConta.hashCode());
        String $ordemBancaria = this.getOrdemBancaria();
        result = result * 59 + ($ordemBancaria == null ? 43 : $ordemBancaria.hashCode());
        String $operacao = this.getOperacao();
        result = result * 59 + ($operacao == null ? 43 : $operacao.hashCode());
        LocalDate $dataAbertura = this.getDataAbertura();
        result = result * 59 + ($dataAbertura == null ? 43 : ((Object)$dataAbertura).hashCode());
        LocalDate $dataEncerramento = this.getDataEncerramento();
        result = result * 59 + ($dataEncerramento == null ? 43 : ((Object)$dataEncerramento).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PessoaConta(principal=" + this.getPrincipal() + ", agencia=" + String.valueOf(this.getAgencia()) + ", conta=" + this.getConta() + ", tipoConta=" + String.valueOf(this.getTipoConta()) + ", ordemBancaria=" + this.getOrdemBancaria() + ", operacao=" + this.getOperacao() + ", dataAbertura=" + String.valueOf(this.getDataAbertura()) + ", dataEncerramento=" + String.valueOf(this.getDataEncerramento()) + ")";
    }
}

