/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.PessoaBancoEntidade;
import br.com.elotech.di.domain.PessoaConta;
import br.com.elotech.di.domain.support.ValueObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;

@Entity
@Table(name="unico.bancopessoa")
@DynamicInsert
@DynamicUpdate
@Audited
@Embeddable
public class PessoaBanco
implements EloEntity<Long>,
ValueObject<PessoaBanco> {
    @Id
    @EloSequence(applyOnMerge=true, schema="unico", sequenceName="s_bancopessoa")
    @Caption(value="C\u00f3digo")
    private Long id;
    @Embedded
    @Caption(value="")
    @Valid
    private final PessoaConta conta = new PessoaConta();
    @Caption(value="Conta Sal\u00e1rio")
    private Boolean contaSalario = Boolean.FALSE;
    @EloSequence(applyOnMerge=true, schema="unico", sequenceName="gen_fornecedorbanco")
    private Long codigoTCE;
    private Boolean validaDigito = true;
    private Boolean padraoNovo = false;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="bancopessoa_id", updatable=false, nullable=false)
    @AuditJoinTable(name="unico.banco_bancopessoaentidade_aud")
    private List<PessoaBancoEntidade> codigosTCE = new ArrayList();

    public PessoaBanco withId(Long id) {
        this.id = id;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getContaSalario() {
        return this.contaSalario;
    }

    public void setContaSalario(Boolean contaSalario) {
        this.contaSalario = contaSalario;
    }

    public PessoaConta getConta() {
        return this.conta;
    }

    public Long getCodigoTCE() {
        return this.codigoTCE;
    }

    public void setCodigoTCE(Long codigoTCE) {
        this.codigoTCE = codigoTCE;
    }

    public Boolean getValidaDigito() {
        return this.validaDigito;
    }

    public void setValidaDigito(Boolean validaDigito) {
        this.validaDigito = validaDigito;
    }

    public Boolean getPadraoNovo() {
        return this.padraoNovo;
    }

    public void setPadraoNovo(Boolean padraoNovo) {
        this.padraoNovo = padraoNovo;
    }

    public List<PessoaBancoEntidade> getCodigosTCE() {
        return this.codigosTCE;
    }

    public void setCodigosTCE(List<PessoaBancoEntidade> codigosTCE) {
        this.codigosTCE = codigosTCE;
    }

    public static PessoaBanco copy(PessoaBanco source) {
        PessoaBanco target = new PessoaBanco();
        BeanUtils.copyProperties((Object)target, (Object)source);
        BeanUtils.copyProperties((Object)target.getConta(), (Object)source.getConta());
        target.setId(null);
        return target;
    }

    public boolean isSame(PessoaBanco other) {
        return this.codigoTCE.equals(other.getCodigoTCE()) && this.getConta().getAgencia().equals((Object)other.getConta().getAgencia()) && this.getConta().getConta().equals(other.getConta().getConta());
    }

    public void calculeValidaDigito() {
        this.validaDigito = Optional.ofNullable(this.conta).map(conta -> conta.hasDigito()).orElse(false);
    }

    @Generated
    public String toString() {
        return "PessoaBanco(id=" + this.getId() + ", conta=" + String.valueOf(this.getConta()) + ", contaSalario=" + this.getContaSalario() + ", codigoTCE=" + this.getCodigoTCE() + ", validaDigito=" + this.getValidaDigito() + ", padraoNovo=" + this.getPadraoNovo() + ", codigosTCE=" + String.valueOf(this.getCodigosTCE()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PessoaBanco)) {
            return false;
        }
        PessoaBanco other = (PessoaBanco)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PessoaBanco;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

