/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.caelum.stella.bean.validation.CNPJ;
import br.com.caelum.stella.bean.validation.CPF;
import br.com.caelum.stella.bean.validation.NIT;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.enumerable.common.CheckPessoaFisica;
import br.com.elotech.core.enumerable.common.CheckPessoaJuridica;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.metamodel.annotation.CalculatedModel;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.support.PessoaValidationGroupsQuery;
import br.com.elotech.core.web.advice.JsonFilterFields;
import br.com.elotech.di.domain.Cnae;
import br.com.elotech.di.domain.Contato;
import br.com.elotech.di.domain.Crnm;
import br.com.elotech.di.domain.Documento;
import br.com.elotech.di.domain.Endereco;
import br.com.elotech.di.domain.IndicePessoa;
import br.com.elotech.di.domain.Nif;
import br.com.elotech.di.domain.Passaporte;
import br.com.elotech.di.domain.PessoaAlteraRazao;
import br.com.elotech.di.domain.PessoaBanco;
import br.com.elotech.di.domain.PessoaCampoCustomizado;
import br.com.elotech.di.domain.PessoaConsorciada;
import br.com.elotech.di.domain.PessoaConta;
import br.com.elotech.di.domain.PessoaContato;
import br.com.elotech.di.domain.PessoaDoc;
import br.com.elotech.di.domain.PessoaDocumento;
import br.com.elotech.di.domain.PessoaEndereco;
import br.com.elotech.di.domain.PessoaImagem;
import br.com.elotech.di.domain.PessoaOcorrencia;
import br.com.elotech.di.domain.PessoaRH;
import br.com.elotech.di.domain.PessoaRHComum;
import br.com.elotech.di.domain.PessoaSituacao;
import br.com.elotech.di.domain.PessoaSocio;
import br.com.elotech.di.domain.RamoAtividade;
import br.com.elotech.di.domain.Rg;
import br.com.elotech.di.domain.TipoConta;
import br.com.elotech.di.domain.TipoUnidadeGestora;
import br.com.elotech.di.domain.aise.AisePessoa;
import br.com.elotech.di.domain.aise.AisePessoaCodigo;
import br.com.elotech.di.domain.apice.ApicePessoa;
import br.com.elotech.di.domain.apice.ApicePessoaCodigo;
import br.com.elotech.di.domain.protocolo.ProtocoloPessoa;
import br.com.elotech.di.domain.protocolo.ProtocoloPessoaCodigo;
import br.com.elotech.di.domain.siscop.SiscopFornecedor;
import br.com.elotech.di.domain.siscop.SiscopFornecedorCodigo;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.EntityPublisher;
import br.com.elotech.di.service.PessoaUtils;
import br.com.elotech.di.validation.SkipBatch;
import br.com.elotech.unico.client.domain.enums.GrauInstrucao;
import br.com.elotech.unico.client.domain.enums.PessoaCorPele;
import br.com.elotech.unico.client.domain.enums.PessoaDeficiencia;
import br.com.elotech.unico.client.domain.enums.PessoaEstadoCivil;
import br.com.elotech.unico.client.domain.enums.PessoaNacionalidade;
import br.com.elotech.unico.client.domain.enums.PessoaSexo;
import br.com.elotech.unico.client.domain.enums.PessoaTipoEmpresa;
import br.com.elotech.unico.client.dto.CrnmDTO;
import br.com.elotech.unico.client.dto.DocumentoDTO;
import br.com.elotech.unico.client.dto.EnderecoDTO;
import br.com.elotech.unico.client.dto.PaisDTO;
import br.com.elotech.unico.client.dto.PassaporteDTO;
import br.com.elotech.unico.client.dto.PessoaBancoDTO;
import br.com.elotech.unico.client.dto.PessoaBancoEntidadeDTO;
import br.com.elotech.unico.client.dto.PessoaContaDTO;
import br.com.elotech.unico.client.dto.PessoaContatoDTO;
import br.com.elotech.unico.client.dto.PessoaDTO;
import br.com.elotech.unico.client.dto.PessoaDocDTO;
import br.com.elotech.unico.client.dto.PessoaEnderecoDTO;
import br.com.elotech.unico.client.dto.PessoaNif;
import br.com.elotech.unico.client.dto.PessoaRg;
import br.com.elotech.unico.client.dto.PessoaTipoEmpresaDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.WhereJoinTable;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.pessoa")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
@JsonFilterFields(of={"id", "nome", "tipoPessoa", "cnpjCpf", "formattedCnpjCpf", "inativo", "observacao", "situacao", "ramoAtividades.id", "ramoAtividades.descricao", "inscMunDataVigencia", "protocolo", "nomeFantasia", "dataAberturaCnpj", "nit", "dataInclusao", "pis", "idTcePR", "dataNascimento", "cargo", "dataCadastro", "nire", "contato.telefoneResidencial", "contato.telefoneFax", "contato.telefoneComercial", "contato.brasileiro", "contato.dataJuntaComercial", "contato.representanteLegal", "contato.nome", "contato.telefoneCelular", "contato.homePage", "contato.representante", "contato.rg", "contato.orgaoEmissor", "contato.cpf", "contato.email", "autonomo", "optanteSimples", "codigoSistemaAnterior", "contatos.principal", "contatos.id", "contatos.contato.telefoneResidencial", "contatos.contato.telefoneFax", "contatos.contato.telefoneComercial", "contatos.contato.brasileiro", "contatos.contato.dataJuntaComercial", "contatos.contato.representanteLegal", "contatos.contato.nome", "contatos.contato.telefoneCelular", "contatos.contato.homePage", "contatos.contato.representante", "contatos.contato.rg", "contatos.contato.orgaoEmissor", "contatos.contato.cpf", "contatos.contato.email", "inscMunDataRenovacao", "contribuinte", "entidadeEsportiva", "produtorRural", "dataAlteracao", "rg.uf.sigla", "rg.uf.id", "rg.uf.descricao", "rg.uf.pais.id", "rg.uf.pais.descricao", "rg.uf.pais.codigoBacen", "rg.numero", "rg.orgaoEmissor", "rg.dataEmissao", "enderecos.principal", "enderecos.endereco.cidade.uf.sigla", "enderecos.endereco.cidade.uf.id", "enderecos.endereco.cidade.uf.descricao", "enderecos.endereco.cidade.uf.pais.id", "enderecos.endereco.cidade.codigoIbge", "enderecos.endereco.cidade.codigoAplic", "enderecos.endereco.cidade.inativo", "enderecos.endereco.cidade.id", "enderecos.endereco.cidade.descricao", "enderecos.endereco.cidade.codigoNacional", "enderecos.endereco.tipo", "enderecos.endereco.complemento", "enderecos.endereco.numero", "enderecos.endereco.distrito", "enderecos.endereco.condominio", "enderecos.endereco.logradouro.cidade.id", "enderecos.endereco.logradouro.id", "enderecos.endereco.logradouro.descricao", "enderecos.endereco.bairro.cidade.uf.sigla", "enderecos.endereco.bairro.cidade.uf.id", "enderecos.endereco.bairro.cidade.inativo", "enderecos.endereco.bairro.cidade.id", "enderecos.endereco.bairro.inativo", "enderecos.endereco.bairro.id", "enderecos.endereco.bairro.descricao", "enderecos.endereco.cep", "enderecos.id", "enderecos.endereco.logradouro.tipoLogDesc", "rh.cidadeTitulo.uf.sigla", "rh.cidadeTitulo.uf.id", "rh.cidadeTitulo.uf.descricao", "rh.cidadeTitulo.uf.pais.id", "rh.cidadeTitulo.codigoIbge", "rh.cidadeTitulo.codigoAplic", "rh.cidadeTitulo.inativo", "rh.cidadeTitulo.id", "rh.cidadeTitulo.descricao", "rh.cidadeTitulo.codigoNacional", "rh.cidadeNascimento.uf.sigla", "rh.cidadeNascimento.uf.id", "rh.cidadeNascimento.uf.pais.id", "rh.cidadeNascimento.codigoIbge", "rh.cidadeNascimento.codigoAplic", "rh.cidadeNascimento.inativo", "rh.cidadeNascimento.id", "rh.cidadeNascimento.descricao", "rh.conjuge", "rh.comum.olhos", "rh.comum.livroCertidaoObito", "rh.comum.cor", "rh.comum.carteiraModelo19", "rh.comum.reservista", "rh.comum.categoriaReservista", "rh.comum.dataObito", "rh.comum.sinais", "rh.comum.cabelo", "rh.comum.registroProfissional", "rh.comum.certidaoObito", "rh.comum.certidaoNascimento", "rh.comum.folhaCertidaoNasc", "rh.comum.dataExpedicaoCNH", "rh.comum.dataPis", "rh.comum.zonaEleitoral", "rh.comum.dataRegistroPro", "rh.comum.secaoEleitoral", "rh.comum.ctps", "rh.comum.dataChegada", "rh.comum.folhaCertidaoObito", "rh.comum.dataExpedicaoCtps", "rh.comum.cnh", "rh.comum.orgaoRegistroPro", "rh.comum.categoriaCNH", "rh.comum.observacaoCNH", "rh.comum.peso", "rh.comum.serieCtps", "rh.comum.estadoCtps", "rh.comum.carteiraDigital", "rh.comum.estadoCivil", "rh.comum.inscricaoINSS", "rh.comum.dataINSS", "rh.comum.livroCertidaoNasc", "rh.comum.altura", "rh.comum.prontuarioCNH", "rh.comum.regiaoReservista", "rh.comum.dataValidadeCNH", "rh.comum.deficiente", "rh.comum.nomePai", "rh.comum.tituloEleitor", "rh.comum.sexo", "rh.comum.nacionalidade", "rh.comum.nomeMae", "rh.comum.causaMorte", "rh.comum.tipoSanguineo", "inscricaoEstadual", "pessoal", "matricula", "estrangeiro", "microEmpresa", "alteracoesRazao.inicioVigencia", "alteracoesRazao.nomeNovo", "alteracoesRazao.id", "alteracoesRazao.nomeAntigo", "alteracoesRazao.motivacao", "dataIniSuspensao", "dataFimSuspensao", "observacaoJudicial", "oab", "documentos.doc.dataValidade", "documentos.doc.documento.tipoDocumento", "documentos.doc.documento.codigoTce", "documentos.doc.documento.classificacao", "documentos.doc.documento.id", "documentos.doc.documento.possuiValidade", "documentos.doc.documento.apresentadoPor", "documentos.doc.documento.descricao", "documentos.doc.arquivo.id", "documentos.doc.arquivo.nome", "documentos.doc.arquivo.dataCriacao", "documentos.doc.arquivo.mimeType", "documentos.doc.arquivo.fullPath", "documentos.doc.numeroDocumento", "documentos.doc.dataEmissao", "documentos.doc.dataAlteracao", "documentos.id", "documentos.doc.usuarioDocumento", "documentos.doc.nomeUsuarioDocumento", "ocorrencias.id", "ocorrencias.sequencia", "ocorrencias.data", "ocorrencias.dataPublicacao", "ocorrencias.tipo.id", "ocorrencias.tipo.descricao", "ocorrencias.tipo.controlaRestricao", "ocorrencias.observacao", "ocorrencias.status", "ocorrencias.dataRestricaoInicio", "ocorrencias.tipo.descricao", "ocorrencias.fundamento", "ocorrencias.arquivo.nome", "ocorrencias.dataRestricaoFim", "ocorrencias.arquivo.id", "ocorrencias.arquivo.dataCriacao", "ocorrencias.arquivo.mimeType", "ocorrencias.arquivo.fullPath", "audespEspecial", "cau", "escolaridade", "cnae.codigo", "cnae.admiteMovimento", "cnae.id", "cnae.descricao", "endereco.cidade.uf.sigla", "endereco.cidade.uf.id", "endereco.cidade.uf.descricao", "endereco.cidade.uf.pais.id", "endereco.cidade.codigoIbge", "endereco.cidade.codigoAplic", "endereco.cidade.inativo", "endereco.cidade.id", "endereco.cidade.descricao", "endereco.cidade.codigoNacional", "endereco.tipo", "endereco.complemento", "endereco.numero", "endereco.logradouro.cidade.id", "endereco.logradouro.id", "endereco.logradouro.descricao", "endereco.bairro.cidade.uf.sigla", "endereco.bairro.cidade.uf.id", "endereco.bairro.cidade.inativo", "endereco.bairro.cidade.id", "endereco.bairro.inativo", "endereco.bairro.id", "endereco.bairro.descricao", "endereco.cep", "crea", "audespGenerica", "inscricaoMunicipal", "responsavelliquidacao", "tipoEmpresa", "fornecedor", "consorcio", "dataIssqn", "restricaojudicial", "capitalsocial", "datacapitalsocial", "socios.socio.funcao", "socios.socio.socio.nome", "socios.socio.socio.id", "socios.socio.socio.cnpjCpf", "socios.socio.dataRegistro", "socios.socio.tipoRegistro", "socios.socio.numeroRegistro", "socios.socio.participacao", "socios.socio.dataDesligamento", "socios.id", "consorciados.consorciado.id", "consorciados.consorciado.nome", "consorciados.consorciado.nome", "consorciados.consorciado.cnpjCpf", "consorciados.id", "consorciados.percentual", "codigoProtocolo", "codigoSiscop", "codigoAise", "codigoApice", "banco.principal", "banco.dataEncerramento", "banco.operacao", "banco.conta", "banco.ordemBancaria", "banco.agencia.codigo", "banco.agencia.cidade.uf.sigla", "banco.agencia.cidade.uf.id", "banco.agencia.cidade.uf.pais.id", "banco.agencia.cidade.codigoIbge", "banco.agencia.cidade.id", "banco.agencia.cidade.descricao", "banco.agencia.banco.codigo", "banco.agencia.cidade.inativo", "banco.agencia.banco.id", "banco.agencia.banco.descricao", "banco.agencia.id", "banco.agencia.descricao", "banco.tipoConta", "banco.dataAbertura", "bancosPessoa.conta.principal", "bancosPessoa.contaSalario", "bancosPessoa.conta.dataEncerramento", "bancosPessoa.conta.operacao", "bancosPessoa.conta.conta", "bancosPessoa.conta.ordemBancaria", "bancosPessoa.conta.agencia.codigo", "bancosPessoa.conta.agencia.cidade.uf.sigla", "bancosPessoa.conta.agencia.cidade.uf.id", "bancosPessoa.conta.agencia.cidade.uf.pais.id", "bancosPessoa.conta.agencia.cidade.codigoIbge", "bancosPessoa.conta.agencia.cidade.inativo", "bancosPessoa.conta.agencia.cidade.id", "bancosPessoa.conta.agencia.cidade.descricao", "bancosPessoa.conta.agencia.banco.codigo", "bancosPessoa.conta.agencia.banco.id", "bancosPessoa.conta.agencia.banco.descricao", "bancosPessoa.conta.agencia.id", "bancosPessoa.conta.agencia.descricao", "bancosPessoa.conta.tipoConta", "bancosPessoa.conta.dataAbertura", "bancosPessoa.codigosTCE.entidade.id", "bancosPessoa.codigosTCE.entidade.nome", "bancosPessoa.codigosTCE.codigoTCE", "bancosPessoa.codigosTCE.id", "bancosPessoa.codigoTCE", "bancosPessoa.validaDigito", "bancosPessoa.id", "bancosPessoa.padraoNovo", "imagens.arquivo.nome", "imagens.arquivo.content.binary", "imagens.arquivo.content.id", "imagens.arquivo.mimeType", "imagens.imagem", "imagens.arquivo.id", "imagens.arquivo.dataCriacao", "imagens.id", "imagens.principal", "cnae.situacaoSna", "cnae.situacaoMei", "cnae.inicioValidade", "cnae.classificacaoAtividade", "cnae.valorBaseCalculo", "cnae.grauRisco", "empresaRegional", "protocoloPessoa.pessoa", "siscopPessoa.codigo", "apicePessoa.pessoa", "aisePessoa.pessoa", "agricultorFamiliar", "rh.comum.ufExpedicaoCNH", "rh.comum.numeroRIC", "rh.comum.dataExpedicaoRIC", "rh.comum.dataValidadeRIC", "rh.comum.orgaoEmissorRIC", "rh.comum.ufEmissorRIC", "rh.comum.ufExpedicaoRNE", "rh.comum.rneOrgaoEmissor", "rh.comum.rneDataExpedicao", "rh.categoriaRegistroProfissional", "rh.emissaoRegistroProfissional", "rh.validadeRegistroProfissional", "rh.observacaoRegistroProfissional", "campocustomizados.id", "campocustomizados.campoCustomizado.id", "campocustomizados.valor", "dataMaximaRestricao", "possuiRestricao", "nomeSocial", "objetoSocial", "inabilitadoContratosFuturos", "pessoaEnderecoPrincipal.endereco.logradouro.descricao", "pessoaEnderecoPrincipal.endereco.bairro.id", "pessoaEnderecoPrincipal.endereco.bairro.descricao", "pessoaEnderecoPrincipal.endereco.logradouro.id", "pessoaEnderecoPrincipal.endereco.numero", "pessoaEnderecoPrincipal.endereco.complemento", "pessoaEnderecoPrincipal.endereco.cidade.id", "pessoaEnderecoPrincipal.endereco.cidade.descricao", "indices.id", "indices.dataCadastro", "indices.ano", "indices.ativoCirculante", "indices.ativoNaoCirculante", "indices.ativoTotal", "indices.patrimonioLiquido", "indices.passivoCirculante", "indices.passivoNaoCirculante", "indices.indiceSolvencia", "indices.capitalSocial", "indices.observacao", "nif.numero", "nif.dataEmissao", "crnm.numero", "crnm.dataEmissao", "crnm.dataValidade", "passaporte.numero", "passaporte.dataEmissao", "passaporte.dataValidade", "passaporte.paisEmissor", "passaporte.paisEmissor.id", "passaporte.paisEmissor.descricao", "passaporte.codigoBacen", "rh.cpfMae", "rh.cpfPai", "crc", "tipoUnidadeGestora.descricao", "tipoUnidadeGestora.codigoTCE"})
public class Pessoa
extends EloDomain<Long>
implements PessoaValidationGroupsQuery,
EntityPublisher<PessoaDTO, Long> {
    @Id
    @EloSequence
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotBlank(groups={SkipBatch.class})
    @Length(min=3, max=150)
    @Caption(value="Nome")
    private @NotBlank(groups={SkipBatch.class}) @Length(min=3, max=150) String nome;
    @Column(length=1)
    @Caption(value="Tipo Pessoa")
    private TipoPessoa tipoPessoa = TipoPessoa.FISICA;
    @Column(name="cnpj_cpf")
    @Length(max=20)
    @Caption(value="Cpf/Cnpj")
    @CPF(groups={CheckPessoaFisica.class})
    @CNPJ(groups={CheckPessoaJuridica.class})
    private @Length(max=20) String cnpjCpf;
    @Embedded
    @Caption(value="RG")
    @Valid
    private Rg rg;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Valid
    @Caption(value="Endere\u00e7os")
    @AuditJoinTable(name="unico.pessoa_enderecopessoa_aud")
    private final List<PessoaEndereco> enderecos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Valid
    @Caption(value="Bancos")
    @AuditJoinTable(name="unico.pessoa_bancopessoa_aud")
    private final List<PessoaBanco> bancosPessoa = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Valid
    @Caption(value="Contatos")
    @AuditJoinTable(name="unico.pessoa_contatopessoa_aud")
    @OrderBy(value="id")
    private final List<PessoaContato> contatos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Valid
    @Caption(value="Documentos")
    @AuditJoinTable(name="unico.pessoa_documentopessoa_aud")
    private final List<PessoaDocumento> documentos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Valid
    @AuditJoinTable(name="unico.pessoa_sociopessoa_aud")
    private final List<PessoaSocio> socios = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Valid
    @AuditJoinTable(name="unico.pessoa_pessoaconsorciada_aud")
    private final List<PessoaConsorciada> consorciados = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Valid
    @AuditJoinTable(name="unico.pessoa_imagempessoa_aud")
    private final List<PessoaImagem> imagens = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="id_pessoa", updatable=false, nullable=false)
    @Valid
    @AuditJoinTable(name="unico.pessoa_campo_customizados_aud")
    private final List<PessoaCampoCustomizado> campocustomizados = new ArrayList();
    @OrderBy(value="sequencia ASC")
    @OneToMany(mappedBy="pessoa", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Valid
    @Caption(value="Ocorr\u00eancias")
    @AuditJoinTable(name="unico.pessoa_pessoaocorrencia_aud")
    private final List<PessoaOcorrencia> ocorrencias = new ArrayList();
    @OneToMany(mappedBy="pessoa", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Caption(value="\u00cdndices")
    @AuditJoinTable(name="unico.indicepessoa_aud")
    private final List<IndicePessoa> indices = new ArrayList();
    @Caption(value="Restri\u00e7\u00e3o Judicial")
    private Boolean restricaojudicial = Boolean.FALSE;
    @Caption(value="Respons\u00e1vel Liquida\u00e7\u00e3o")
    private Boolean responsavelliquidacao = Boolean.FALSE;
    @Caption(value="Micro Empresa")
    private Boolean microEmpresa = Boolean.FALSE;
    @Caption(value="Auton\u00f4mo")
    private Boolean autonomo = Boolean.FALSE;
    @Caption(value="Estrangeiro")
    private Boolean estrangeiro = Boolean.FALSE;
    @Caption(value="Contribuinte")
    private Boolean contribuinte = Boolean.FALSE;
    @Caption(value="Entidade Esportiva")
    private Boolean entidadeEsportiva = Boolean.FALSE;
    @Caption(value="Produtor Rural")
    private Boolean produtorRural = Boolean.FALSE;
    @Caption(value="Fornecedor")
    private Boolean fornecedor = Boolean.FALSE;
    @Caption(value="Consorcio")
    private Boolean consorcio = Boolean.FALSE;
    @Caption(value="Funcionario")
    private Boolean pessoal = Boolean.FALSE;
    @Caption(value="Protocolo")
    private Boolean protocolo = Boolean.FALSE;
    @Caption(value="Inativo")
    private Boolean inativo = Boolean.FALSE;
    @Caption(value="Optante Simples")
    private Boolean optanteSimples = Boolean.FALSE;
    @Caption(value="Empresa Regional")
    private Boolean empresaRegional = Boolean.FALSE;
    @Caption(value="Agricultor Familiar")
    private Boolean agricultorFamiliar = Boolean.FALSE;
    @Caption(value="Inabilitado Contratos Futuros")
    private Boolean inabilitadoContratosFuturos = Boolean.FALSE;
    @Length(max=20)
    @Caption(value="Inscri\u00e7\u00e3o Estadual")
    private @Length(max=20) String inscricaoEstadual;
    @Length(max=150)
    @Caption(value="Nome Fantasia")
    private @Length(max=150) String nomeFantasia;
    @Length(max=1000)
    @Caption(value="Observa\u00e7\u00e3o")
    private @Length(max=1000) String observacao;
    @Length(max=1000)
    @Caption(value="Observa\u00e7\u00e3o Judicial")
    private @Length(max=1000) String observacaoJudicial;
    @Caption(value="Id Tce PR")
    private Long idTcePR;
    @Caption(value="Data Inclus\u00e3o")
    private LocalDate dataInclusao = LocalDate.now();
    @Caption(value="Data Altera\u00e7\u00e3o")
    private LocalDateTime dataAlteracao;
    @Caption(value="Data Cadastro")
    private LocalDate dataCadastro;
    @Length(max=20)
    @Caption(value="Pis")
    @NIT(groups={SkipBatch.class})
    private @Length(max=20) String pis;
    @Length(max=20)
    @Caption(value="Inscri\u00e7\u00e3o Municipal")
    private @Length(max=20) String inscricaoMunicipal;
    @Caption(value="Escolaridade")
    private GrauInstrucao escolaridade;
    @Caption(value="Situa\u00e7\u00e3o")
    private PessoaSituacao situacao = PessoaSituacao.DEFAULT;
    @Caption(value="Tipo Empresa")
    @Valid
    private PessoaTipoEmpresa tipoEmpresa;
    @Caption(value="Data Nascimento")
    private LocalDate dataNascimento;
    @Length(max=20)
    @Caption(value="Audesp Inscri\u00e7\u00e3o Gen\u00e9rica")
    private @Length(max=20) String audespGenerica;
    @Length(max=20)
    @Caption(value="Audesp Inscri\u00e7\u00e3o Especial")
    private @Length(max=20) String audespEspecial;
    @Caption(value="Data Renova\u00e7\u00e3o da Inscri\u00e7\u00e3o Municipal")
    private LocalDate inscMunDataRenovacao;
    @Length(max=15)
    @Caption(value="CAU")
    private @Length(max=15) String cau;
    @Length(max=15)
    @Caption(value="CREA")
    private @Length(max=15) String crea;
    @Length(max=15)
    @Caption(value="OAB")
    private @Length(max=15) String oab;
    @Length(max=15)
    @Caption(value="CRC")
    private @Length(max=15) String crc;
    @Caption(value="Data vig\u00eancia da inscri\u00e7\u00e3o Municipal")
    private LocalDate inscMunDataVigencia;
    @Caption(value="Data final de supens\u00e3o")
    private LocalDate dataFimSuspensao;
    @Caption(value="Data in\u00edcio de supens\u00e3o")
    private LocalDate dataIniSuspensao;
    @Length(max=50)
    @Caption(value="Cargo")
    private @Length(max=50) String cargo;
    @Length(max=20)
    @Caption(value="Matr\u00edcula")
    private @Length(max=20) String matricula;
    @Caption(value="Data Abertura Cnpj")
    private LocalDate dataAberturaCnpj;
    @Caption(value="Data ISSQN")
    private LocalDate dataIssqn;
    @Length(max=12)
    @Caption(value="NIRE")
    private @Length(max=12) String nire;
    @Length(max=12)
    @Caption(value="NIT")
    private @Length(max=12) String nit;
    @Length(max=18)
    @Caption(value="C\u00f3digo Sistema Anterior")
    private @Length(max=18) String codigoSistemaAnterior;
    @ManyToOne
    @Caption(value="Cnae")
    private Cnae cnae;
    @Caption(value="Capital social")
    private Double capitalsocial;
    @Caption(value="Data capital social")
    private LocalDate datacapitalsocial;
    @OneToMany
    @Caption(value="Ramos")
    @JoinTable(name="unico.pessoa_ramoatividade", joinColumns={@JoinColumn(name="pessoa", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="ramoatividade", referencedColumnName="id")})
    private final Set<RamoAtividade> ramoAtividades = new HashSet();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Valid
    @Caption(value="Altera\u00e7\u00f5es Raz\u00e3o")
    @AuditJoinTable(name="unico.pessoa_pessoaalterarazao_aud")
    private final List<PessoaAlteraRazao> alteracoesRazao = new ArrayList();
    @Embedded
    @Valid
    @Caption(value="")
    private PessoaRH rh;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinFormula(value="id", referencedColumnName="idUnico")
    @NotAudited
    private AisePessoaCodigo aisePessoa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinFormula(value="id", referencedColumnName="idUnico")
    @NotAudited
    private SiscopFornecedorCodigo siscopPessoa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinFormula(value="id", referencedColumnName="idUnico")
    @NotAudited
    private ApicePessoaCodigo apicePessoa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinFormula(value="id", referencedColumnName="idUnico")
    @NotAudited
    private ProtocoloPessoaCodigo protocoloPessoa;
    @NotAudited
    @Caption(value="Possui Restri\u00e7\u00e3o")
    @Formula(value="(select case when exists(select * from {SCHEMA_UNICO}.pessoaocorrencia po                         inner join {SCHEMA_UNICO}.tipoocorrencia tpo on tpo.id = po.tipoocorrencia_id                         where po.pessoa_id = p.id and tpo.controlarestricao = 'S')                then 'S' else 'N' end                 from {SCHEMA_UNICO}.pessoa p                 where p.id = id)")
    private Boolean possuiRestricao;
    @NotAudited
    @Caption(value="Data M\u00e1xima Restri\u00e7\u00e3o")
    @Formula(value="(select max(po.datarestricaofim) from {SCHEMA_UNICO}.pessoaocorrencia po      where po.pessoa_id = id)")
    private LocalDate dataMaximaRestricao;
    @NotAudited
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean enviaParaEsocial = Boolean.FALSE;
    @Caption(value="Nome Social")
    @Length(max=150)
    private @Length(max=150) String nomeSocial;
    @Caption(value="Objeto Social")
    @Length(max=1000)
    private @Length(max=1000) String objetoSocial;
    @ManyToMany
    @JsonIgnore
    @JoinTable(name="unico.enderecopessoa", joinColumns={@JoinColumn(name="pessoa")}, inverseJoinColumns={@JoinColumn(name="id")})
    @WhereJoinTable(clause=" principal = 'S' ")
    @NotAudited
    private List<PessoaEndereco> pessoaEnderecoPrincipal = new ArrayList();
    @Embedded
    @Caption(value="NIF")
    @Valid
    private Nif nif;
    @Embedded
    @Caption(value="Carteira de Registro Nacional Migrat\u00f3rio")
    private Crnm crnm;
    @Embedded
    private Passaporte passaporte;
    @Transient
    private Boolean isServiceAccount = Boolean.FALSE;
    @Caption(value="Tipo Unidade Gestora")
    @ManyToOne
    @JoinColumn(name="tipounidadegestora")
    @NotAudited
    private TipoUnidadeGestora tipoUnidadeGestora;

    @JsonProperty
    public PessoaEndereco getPessoaEnderecoPrincipal() {
        return this.pessoaEnderecoPrincipal.isEmpty() ? null : (PessoaEndereco)this.pessoaEnderecoPrincipal.get(0);
    }

    public void setPossuiRestricao(Boolean possuiRestricao) {
        this.possuiRestricao = possuiRestricao;
    }

    public Boolean getPossuiRestricao() {
        return this.possuiRestricao;
    }

    public void setDataMaximaRestricao(LocalDate dataMaximaRestricao) {
        this.dataMaximaRestricao = dataMaximaRestricao;
    }

    public LocalDate getDataMaximaRestricao() {
        return this.dataMaximaRestricao;
    }

    public void setRh(PessoaRH pessoaRH) {
        this.rh = pessoaRH;
    }

    public PessoaRH getRh() {
        return this.rh;
    }

    public Set<RamoAtividade> getRamoAtividades() {
        return this.ramoAtividades;
    }

    public void setCnae(Cnae cnae) {
        this.cnae = cnae;
    }

    public Cnae getCnae() {
        return this.cnae;
    }

    public Rg getRg() {
        return this.rg;
    }

    public void setInscricaoEstadual(String inscricaoEstadual) {
        this.inscricaoEstadual = inscricaoEstadual;
    }

    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void setObservacaoJudicial(String observacaoJudicial) {
        this.observacaoJudicial = observacaoJudicial;
    }

    public void setIdTcePR(Long idTcePR) {
        this.idTcePR = idTcePR;
    }

    public void setDataAlteracao(LocalDateTime dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public void setDataCadastro(LocalDate dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setPis(String pis) {
        this.pis = pis;
    }

    public void setResponsavelliquidacao(Boolean responsavelliquidacao) {
        this.responsavelliquidacao = BooleanUtils.toBoolean((Boolean)responsavelliquidacao);
    }

    public void setRestricaojudicial(Boolean restricaojudicial) {
        this.restricaojudicial = BooleanUtils.toBoolean((Boolean)restricaojudicial);
    }

    public List<PessoaEndereco> getEnderecos() {
        return this.enderecos;
    }

    public List<PessoaCampoCustomizado> getCampocustomizados() {
        return this.campocustomizados;
    }

    public List<PessoaOcorrencia> getOcorrencias() {
        return this.ocorrencias;
    }

    public List<IndicePessoa> getIndices() {
        return this.indices;
    }

    public String getNome() {
        return this.nome;
    }

    public void setRg(Rg rg) {
        this.rg = rg;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public Nif getNif() {
        return this.nif;
    }

    public void setNif(Nif nif) {
        this.nif = nif;
    }

    public Crnm getCrnm() {
        return this.crnm;
    }

    public void setCrnm(Crnm crnm) {
        this.crnm = crnm;
    }

    public Passaporte getPassaporte() {
        return this.passaporte;
    }

    public void setPassaporte(Passaporte passaporte) {
        this.passaporte = passaporte;
    }

    public TipoUnidadeGestora getTipoUnidadeGestora() {
        return this.tipoUnidadeGestora;
    }

    public void setTipoUnidadeGestora(TipoUnidadeGestora tipoUnidadeGestora) {
        this.tipoUnidadeGestora = tipoUnidadeGestora;
    }

    PessoaSexo getSexo() {
        if (Objects.isNull(this.rh)) {
            return null;
        }
        return this.rh.getComum().getSexo();
    }

    PessoaCorPele getCor() {
        if (Objects.isNull(this.rh)) {
            return null;
        }
        return this.rh.getComum().getCor();
    }

    PessoaEstadoCivil getEstadoCivil() {
        if (Objects.isNull(this.rh)) {
            return null;
        }
        return this.rh.getComum().getEstadoCivil();
    }

    PessoaNacionalidade getNacionalidade() {
        if (Objects.isNull(this.rh)) {
            return null;
        }
        return this.rh.getComum().getNacionalidade();
    }

    PessoaDeficiencia getDeficiente() {
        if (Objects.isNull(this.rh)) {
            return null;
        }
        return this.rh.getComum().getDeficiente();
    }

    public Pessoa withNome(String nome) {
        this.nome = nome;
        return this;
    }

    public Pessoa withTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
        return this;
    }

    public Pessoa withPessoal(Boolean pessoal) {
        this.pessoal = pessoal;
        return this;
    }

    public Pessoa withPis(String pis) {
        this.pis = pis;
        return this;
    }

    public Pessoa withFornecedor(Boolean fornecedor) {
        this.fornecedor = fornecedor;
        return this;
    }

    public Pessoa withConsorcio(Boolean consorcio) {
        this.consorcio = consorcio;
        return this;
    }

    public Pessoa withProtocolo(Boolean protocolo) {
        this.protocolo = protocolo;
        return this;
    }

    public Pessoa withContribuinte(Boolean contribuinte) {
        this.contribuinte = contribuinte;
        return this;
    }

    public Pessoa withCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
        return this;
    }

    public Pessoa withId(Long id) {
        this.setId(id);
        return this;
    }

    public Pessoa withRg(Rg rg) {
        this.rg = rg;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getRestricaojudicial() {
        return this.restricaojudicial;
    }

    public Boolean getResponsavelliquidacao() {
        return this.responsavelliquidacao;
    }

    public Boolean getMicroEmpresa() {
        return this.microEmpresa;
    }

    public void setMicroEmpresa(Boolean microEmpresa) {
        this.microEmpresa = BooleanUtils.toBoolean((Boolean)microEmpresa);
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public String getObservacaoJudicial() {
        return this.observacaoJudicial;
    }

    public Long getIdTcePR() {
        return this.idTcePR;
    }

    public LocalDateTime getDataAlteracao() {
        return this.dataAlteracao;
    }

    public LocalDate getDataCadastro() {
        return this.dataCadastro;
    }

    public String getPis() {
        return this.pis;
    }

    public void setInscricaoMunicipal(String inscricaoMunicipal) {
        this.inscricaoMunicipal = inscricaoMunicipal;
    }

    public String getInscricaoMunicipal() {
        return this.inscricaoMunicipal;
    }

    public Boolean getAutonomo() {
        return this.autonomo;
    }

    public Boolean getContribuinte() {
        return BooleanUtils.isTrue((Boolean)this.contribuinte);
    }

    public Boolean getEstrangeiro() {
        return this.estrangeiro;
    }

    public Boolean getFornecedor() {
        return BooleanUtils.isTrue((Boolean)this.fornecedor);
    }

    public Boolean getConsorcio() {
        return BooleanUtils.isTrue((Boolean)this.consorcio);
    }

    public Boolean getPessoal() {
        return BooleanUtils.isTrue((Boolean)this.pessoal);
    }

    public Boolean getInativo() {
        return this.inativo;
    }

    public void setAutonomo(Boolean autonomo) {
        this.autonomo = BooleanUtils.toBoolean((Boolean)autonomo);
    }

    public void setContribuinte(Boolean contribuinte) {
        this.contribuinte = BooleanUtils.toBoolean((Boolean)contribuinte);
    }

    public void setEntidadeEsportiva(Boolean entidadeEsportiva) {
        this.entidadeEsportiva = BooleanUtils.toBoolean((Boolean)entidadeEsportiva);
    }

    public Boolean getEntidadeEsportiva() {
        return this.entidadeEsportiva;
    }

    public void setProdutorRural(Boolean produtorRural) {
        this.produtorRural = BooleanUtils.toBoolean((Boolean)produtorRural);
    }

    public Boolean getProdutorRural() {
        return this.produtorRural;
    }

    public void setEstrangeiro(Boolean estrangeiro) {
        this.estrangeiro = BooleanUtils.toBoolean((Boolean)estrangeiro);
    }

    public void setFornecedor(Boolean fornecedor) {
        this.fornecedor = BooleanUtils.toBoolean((Boolean)fornecedor);
    }

    public void setConsorcio(Boolean consorcio) {
        this.consorcio = BooleanUtils.toBoolean((Boolean)consorcio);
    }

    public void setPessoal(Boolean pessoal) {
        this.pessoal = BooleanUtils.toBoolean((Boolean)pessoal);
    }

    public void setInativo(Boolean inativo) {
        this.inativo = BooleanUtils.toBoolean((Boolean)inativo);
    }

    public PessoaSituacao getSituacao() {
        return this.situacao;
    }

    public PessoaTipoEmpresa getTipoEmpresa() {
        return this.tipoEmpresa;
    }

    public void setSituacao(PessoaSituacao situacao) {
        this.situacao = situacao;
    }

    public void setTipoEmpresa(PessoaTipoEmpresa tipoEmpresa) {
        this.tipoEmpresa = tipoEmpresa;
    }

    public LocalDate getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(LocalDate dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    public Boolean getOptanteSimples() {
        return this.optanteSimples;
    }

    public void setOptanteSimples(Boolean optanteSimples) {
        this.optanteSimples = BooleanUtils.toBoolean((Boolean)optanteSimples);
    }

    public String getAudespGenerica() {
        return this.audespGenerica;
    }

    public String getAudespEspecial() {
        return this.audespEspecial;
    }

    public LocalDate getInscMunDataRenovacao() {
        return this.inscMunDataRenovacao;
    }

    public String getCau() {
        return this.cau;
    }

    public String getCrea() {
        return this.crea;
    }

    public String getOab() {
        return this.oab;
    }

    public String getCrc() {
        return this.crc;
    }

    public LocalDate getInscMunDataVigencia() {
        return this.inscMunDataVigencia;
    }

    public LocalDate getDataFimSuspensao() {
        return this.dataFimSuspensao;
    }

    public LocalDate getDataIniSuspensao() {
        return this.dataIniSuspensao;
    }

    public String getCargo() {
        return this.cargo;
    }

    public void setAudespGenerica(String audespGenerica) {
        this.audespGenerica = audespGenerica;
    }

    public void setAudespEspecial(String audespEspecial) {
        this.audespEspecial = audespEspecial;
    }

    public void setInscMunDataRenovacao(LocalDate inscMunDataRenovacao) {
        this.inscMunDataRenovacao = inscMunDataRenovacao;
    }

    public void setCau(String cau) {
        this.cau = cau;
    }

    public void setCrea(String crea) {
        this.crea = crea;
    }

    public void setOab(String oab) {
        this.oab = oab;
    }

    public void setCrc(String crc) {
        this.crc = crc;
    }

    public void setInscMunDataVigencia(LocalDate inscMunDataVigencia) {
        this.inscMunDataVigencia = inscMunDataVigencia;
    }

    public void setDataFimSuspensao(LocalDate dataFimSuspensao) {
        this.dataFimSuspensao = dataFimSuspensao;
    }

    public void setDataIniSuspensao(LocalDate dataIniSuspensao) {
        this.dataIniSuspensao = dataIniSuspensao;
    }

    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    public String getMatricula() {
        return this.matricula;
    }

    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    public LocalDate getDataAberturaCnpj() {
        return this.dataAberturaCnpj;
    }

    public LocalDate getDataIssqn() {
        return this.dataIssqn;
    }

    public String getNire() {
        return this.nire;
    }

    public String getNit() {
        return this.nit;
    }

    public String getCodigoSistemaAnterior() {
        return this.codigoSistemaAnterior;
    }

    public void setDataAberturaCnpj(LocalDate dataAberturaCnpj) {
        this.dataAberturaCnpj = dataAberturaCnpj;
    }

    public void setDataIssqn(LocalDate dataIssqn) {
        this.dataIssqn = dataIssqn;
    }

    public void setNire(String nire) {
        this.nire = nire;
    }

    public void setNit(String nit) {
        this.nit = nit;
    }

    public void setCodigoSistemaAnterior(String codigoSistemaAnterior) {
        this.codigoSistemaAnterior = codigoSistemaAnterior;
    }

    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public List<PessoaBanco> getBancosPessoa() {
        return this.bancosPessoa;
    }

    public GrauInstrucao getEscolaridade() {
        return this.escolaridade;
    }

    public void setEscolaridade(GrauInstrucao escolaridade) {
        this.escolaridade = escolaridade;
    }

    public Boolean getProtocolo() {
        return BooleanUtils.isTrue((Boolean)this.protocolo);
    }

    public void setProtocolo(Boolean protocolo) {
        this.protocolo = BooleanUtils.toBoolean((Boolean)protocolo);
    }

    @CalculatedModel
    public Endereco getEndereco() {
        for (PessoaEndereco endereco : this.enderecos) {
            if (!Boolean.TRUE.equals(endereco.getPrincipal())) continue;
            return endereco.getEndereco();
        }
        return null;
    }

    public List<PessoaContato> getContatos() {
        return this.contatos;
    }

    @CalculatedModel
    public Contato getContato() {
        for (PessoaContato contato : this.contatos) {
            if (!Boolean.TRUE.equals(contato.getPrincipal())) continue;
            return contato.getContato();
        }
        return null;
    }

    public Contato getSafeContato() {
        return Optional.ofNullable(this.getContato()).orElse(new Contato());
    }

    @CalculatedModel
    public PessoaConta getBanco() {
        for (PessoaBanco banco : this.bancosPessoa) {
            if (!Boolean.TRUE.equals(banco.getConta().getPrincipal())) continue;
            return banco.getConta();
        }
        return null;
    }

    public List<PessoaDocumento> getDocumentos() {
        this.documentos.sort(Comparator.comparing(PessoaDocumento::getDoc, Comparator.nullsFirst(Comparator.comparing(PessoaDoc::getDataValidade, Comparator.nullsFirst(Comparator.reverseOrder())).thenComparing(PessoaDoc::getDocumento, Comparator.nullsFirst(Comparator.comparing(Documento::getDescricao, Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER)))))));
        return this.documentos;
    }

    public List<PessoaSocio> getSocios() {
        return this.socios;
    }

    public List<PessoaConsorciada> getConsorciados() {
        return this.consorciados;
    }

    public List<PessoaAlteraRazao> getAlteracoesRazao() {
        return this.alteracoesRazao;
    }

    public static Pessoa of(Long id) {
        return new Pessoa().withId(id);
    }

    public Pessoa withEmail(String email) {
        return this;
    }

    public Pessoa withCargo(String cargo) {
        this.setCargo(cargo);
        return this;
    }

    public Pessoa withMatricula(String matricula) {
        this.setMatricula(matricula);
        return this;
    }

    @CalculatedModel
    public Long getCodigoSiscop() {
        if (this.siscopPessoa != null) {
            return this.siscopPessoa.getCodigo();
        }
        return null;
    }

    @CalculatedModel
    public Long getCodigoAise() {
        if (this.aisePessoa != null) {
            return this.aisePessoa.getPessoa();
        }
        return null;
    }

    @CalculatedModel
    public Long getCodigoApice() {
        if (this.apicePessoa != null) {
            return this.apicePessoa.getPessoa();
        }
        return null;
    }

    @CalculatedModel
    public Long getCodigoProtocolo() {
        if (this.protocoloPessoa != null) {
            return this.protocoloPessoa.getPessoa();
        }
        return null;
    }

    public List<PessoaImagem> getImagens() {
        return this.imagens;
    }

    public void setImagens(List<PessoaImagem> imagens) {
        this.imagens.clear();
        this.imagens.addAll(imagens);
    }

    public AisePessoaCodigo getAisePessoa() {
        return this.aisePessoa;
    }

    public SiscopFornecedorCodigo getSiscopPessoa() {
        return this.siscopPessoa;
    }

    public ApicePessoaCodigo getApicePessoa() {
        return this.apicePessoa;
    }

    public ProtocoloPessoaCodigo getProtocoloPessoa() {
        return this.protocoloPessoa;
    }

    public Boolean getEmpresaRegional() {
        return this.empresaRegional;
    }

    public void setEmpresaRegional(Boolean empresaRegional) {
        this.empresaRegional = empresaRegional;
    }

    public Boolean getAgricultorFamiliar() {
        return this.agricultorFamiliar;
    }

    public Boolean getInabilitadoContratosFuturos() {
        return this.inabilitadoContratosFuturos;
    }

    public void setAgricultorFamiliar(Boolean agricultorFamiliar) {
        this.agricultorFamiliar = agricultorFamiliar;
    }

    public void setInabilitadoContratosFuturos(Boolean inabilitadoContratosFuturos) {
        this.inabilitadoContratosFuturos = inabilitadoContratosFuturos;
    }

    public Long getCodigoLegadoByClass(Class<?> clazz) {
        if (clazz.equals(AisePessoa.class)) {
            return this.getCodigoAise();
        }
        if (clazz.equals(SiscopFornecedor.class)) {
            return this.getCodigoSiscop();
        }
        if (clazz.equals(ApicePessoa.class)) {
            return this.getCodigoApice();
        }
        if (clazz.equals(ProtocoloPessoa.class)) {
            return this.getCodigoProtocolo();
        }
        throw new IllegalArgumentException();
    }

    public List<Class<?>> queryValidationsGroup() {
        if (StringUtils.isEmpty((String)this.audespEspecial) && StringUtils.isEmpty((String)this.audespGenerica)) {
            return Arrays.asList(this.tipoPessoa.getValidationGroup());
        }
        return Collections.emptyList();
    }

    @CalculatedModel
    public String getFormattedCnpjCpf() {
        return PessoaUtils.getFormattedCnpjCpf((TipoPessoa)this.tipoPessoa, (String)this.cnpjCpf);
    }

    public Double getCapitalsocial() {
        return this.capitalsocial;
    }

    public void setCapitalsocial(Double capitalsocial) {
        this.capitalsocial = capitalsocial;
    }

    public LocalDate getDatacapitalsocial() {
        return this.datacapitalsocial;
    }

    public void setDatacapitalsocial(LocalDate datacapitalsocial) {
        this.datacapitalsocial = datacapitalsocial;
    }

    public Boolean getEnviaParaEsocial() {
        return this.enviaParaEsocial;
    }

    public void setEnviaParaEsocial(Boolean enviaParaEsocial) {
        this.enviaParaEsocial = enviaParaEsocial;
    }

    public String getNomeSocial() {
        return this.nomeSocial;
    }

    public void setNomeSocial(String nomeSocial) {
        this.nomeSocial = nomeSocial;
    }

    public String getObjetoSocial() {
        return this.objetoSocial;
    }

    public void setObjetoSocial(String objetoSocial) {
        this.objetoSocial = objetoSocial;
    }

    public void markEnderecoPrincipalIfNoneExists() {
        if (this.enderecos.stream().noneMatch(PessoaEndereco::getPrincipal)) {
            this.enderecos.stream().findFirst().ifPresent(e -> e.setPrincipal(Boolean.valueOf(true)));
        }
    }

    public void markContatoPrincipalIfNoneExists() {
        if (this.contatos.stream().noneMatch(PessoaContato::getPrincipal)) {
            this.contatos.stream().findFirst().ifPresent(c -> c.setPrincipal(Boolean.valueOf(true)));
        }
    }

    public PessoaDTO convertToEvent() {
        PessoaDTO dto = new PessoaDTO();
        dto.setId(this.id);
        dto.setNome(this.getNome());
        dto.setTipoPessoa((String)Optional.ofNullable(this.tipoPessoa).map(TipoPessoa::getValue).orElse(null));
        dto.setTipoEmpresa((PessoaTipoEmpresaDTO)Optional.ofNullable(this.tipoEmpresa).map(tipo -> new PessoaTipoEmpresaDTO(tipo.getValue(), tipo.getDescricao())).orElse(null));
        dto.setCnpjCpf(this.cnpjCpf);
        dto.setNomeFantasia(this.nomeFantasia);
        dto.setDataCadastro(this.dataCadastro);
        dto.setDataNascimento(this.dataNascimento);
        dto.setInscricaoMunicipal(this.inscricaoMunicipal);
        dto.setInativo(this.inativo);
        dto.setInscricaoEstadual(this.inscricaoEstadual);
        dto.setCargo(this.cargo);
        dto.setMatricula(this.matricula);
        dto.setEntidadeEsportiva(this.entidadeEsportiva);
        dto.setProdutorRural(this.produtorRural);
        dto.setSexo(this.getSexo());
        dto.setCor(this.getCor());
        dto.setEstadoCivil(this.getEstadoCivil());
        dto.setNacionalidade(this.getNacionalidade());
        dto.setDeficiente(this.getDeficiente());
        dto.setEscolaridade(this.getEscolaridade());
        dto.setEnviaParaEsocial(this.getEnviaParaEsocial());
        dto.setNomeSocial(this.getNomeSocial());
        dto.setOptanteSimples(this.getOptanteSimples());
        dto.setIdTcePR(this.getIdTcePR());
        if (Objects.nonNull(this.rg)) {
            dto.setRg(PessoaRg.builder().numero(this.rg.getNumero()).dataEmissao(this.rg.getDataEmissao()).orgaoEmissor(this.rg.getOrgaoEmissor()).build());
        }
        if (Objects.nonNull(this.rh)) {
            dto.setDataObito((LocalDate)Optional.ofNullable(this.rh.getComum()).map(PessoaRHComum::getDataObito).orElse(null));
            if (Objects.nonNull(this.rh.getCidadeNascimento())) {
                dto.setCidadeNascimento(this.rh.getCidadeNascimento().convertToEvent());
            }
        }
        this.createEnderecosDTO(dto);
        this.createContatosDTO(dto);
        this.createBancosPessoaDTO(dto);
        this.createDocumentosDTO(dto);
        Optional.ofNullable(this.situacao).ifPresent(s -> dto.setSituacaoFornecedor(s.getValue()));
        if (Objects.nonNull(this.nif)) {
            dto.setNif(PessoaNif.builder().numero(this.nif.getNumero()).dataEmissao(this.nif.getDataEmissao()).build());
        }
        this.createDocumentosEstrangeiros(dto);
        return dto;
    }

    private void createDocumentosEstrangeiros(PessoaDTO dto) {
        dto.setPassaporte(this.createPassaporte());
        dto.setCrnm(this.createCrnm());
    }

    private PassaporteDTO createPassaporte() {
        PassaporteDTO passaporteDTO = new PassaporteDTO();
        if (Objects.nonNull(this.getPassaporte())) {
            if (Objects.nonNull(this.passaporte.getPaisEmissor())) {
                PaisDTO paisDTO = this.passaporte.getPaisEmissor().convertToEvent();
                passaporteDTO.setPaisEmissor(paisDTO);
            }
            if (Objects.nonNull(this.passaporte.getNumero())) {
                passaporteDTO.setNumero(this.passaporte.getNumero());
            }
            if (Objects.nonNull(this.passaporte.getDataEmissao())) {
                passaporteDTO.setDataEmissao(this.passaporte.getDataEmissao());
            }
            if (Objects.nonNull(this.passaporte.getDataValidade())) {
                passaporteDTO.setDataValidade(this.passaporte.getDataValidade());
            }
        }
        return passaporteDTO;
    }

    private CrnmDTO createCrnm() {
        CrnmDTO crnmDTO = new CrnmDTO();
        if (Objects.nonNull(this.getCrnm())) {
            if (Objects.nonNull(this.crnm.getNumero())) {
                crnmDTO.setNumero(this.crnm.getNumero());
            }
            if (Objects.nonNull(this.crnm.getDataEmissao())) {
                crnmDTO.setDataEmissao(this.crnm.getDataEmissao());
            }
            if (Objects.nonNull(this.crnm.getDataValidade())) {
                crnmDTO.setDataValidade(this.crnm.getDataValidade());
            }
        }
        return crnmDTO;
    }

    private void createBancosPessoaDTO(PessoaDTO dto) {
        List entityBancosPessoa = this.getBancosPessoa();
        dto.getBancosPessoa().clear();
        for (PessoaBanco bancoPessoa : entityBancosPessoa) {
            if (!Objects.nonNull(bancoPessoa.getConta())) continue;
            PessoaContaDTO pessoaContaDTO = new PessoaContaDTO();
            if (Objects.nonNull(bancoPessoa.getConta().getAgencia())) {
                pessoaContaDTO.setAgencia(bancoPessoa.getConta().getAgencia().convertToEvent());
            }
            pessoaContaDTO.setConta(bancoPessoa.getConta().getConta());
            pessoaContaDTO.setDataAbertura(bancoPessoa.getConta().getDataAbertura());
            pessoaContaDTO.setPrincipal(bancoPessoa.getConta().getPrincipal());
            pessoaContaDTO.setTipoConta((String)Optional.ofNullable(bancoPessoa.getConta().getTipoConta()).map(TipoConta::getValue).orElse(null));
            pessoaContaDTO.setDataEncerramento(bancoPessoa.getConta().getDataEncerramento());
            PessoaBancoDTO pessoaBancoDTO = new PessoaBancoDTO();
            pessoaBancoDTO.setConta(pessoaContaDTO);
            this.createBancosPessoaeEntidadeDTO(bancoPessoa, pessoaBancoDTO);
            pessoaBancoDTO.setId(bancoPessoa.getId());
            dto.getBancosPessoa().add(pessoaBancoDTO);
        }
    }

    private void createBancosPessoaeEntidadeDTO(PessoaBanco pessoaBanco, PessoaBancoDTO dto) {
        dto.getCodigosTCE().clear();
        dto.getCodigosTCE().addAll(pessoaBanco.getCodigosTCE().stream().map(codigoTCE -> PessoaBancoEntidadeDTO.builder().id(codigoTCE.getId()).codigoTCE(codigoTCE.getCodigoTCE()).entidade(codigoTCE.getEntidade().convertToEvent()).build()).collect(Collectors.toList()));
    }

    private void createContatosDTO(PessoaDTO dto) {
        List entityContatos = this.getContatos();
        dto.getContatos().clear();
        for (PessoaContato pessoaContato : entityContatos) {
            if (!Objects.nonNull(pessoaContato.getContato())) continue;
            Contato contato = pessoaContato.getContato();
            PessoaContatoDTO pessoaContatoDTO = new PessoaContatoDTO();
            pessoaContatoDTO.setContato(contato.getContatoDTO());
            pessoaContatoDTO.setPrincipal(pessoaContato.getPrincipal());
            pessoaContatoDTO.setId(pessoaContato.getId());
            dto.getContatos().add(pessoaContatoDTO);
        }
    }

    private void createEnderecosDTO(PessoaDTO dto) {
        List entityEnderecos = this.getEnderecos();
        dto.getEnderecos().clear();
        for (PessoaEndereco enderecoPessoa : entityEnderecos) {
            if (!Objects.nonNull(enderecoPessoa.getEndereco())) continue;
            EnderecoDTO enderecoDTO = new EnderecoDTO();
            if (Objects.nonNull(enderecoPessoa.getEndereco().getBairro())) {
                enderecoDTO.setBairro(enderecoPessoa.getEndereco().getBairro().convertToEvent());
            }
            if (Objects.nonNull(enderecoPessoa.getEndereco().getCidade())) {
                enderecoDTO.setCidade(enderecoPessoa.getEndereco().getCidade().convertToEvent());
            }
            if (Objects.nonNull(enderecoPessoa.getEndereco().getLogradouro())) {
                enderecoDTO.setLogradouro(enderecoPessoa.getEndereco().getLogradouro().convertToEvent());
            }
            enderecoDTO.setComplemento(enderecoPessoa.getEndereco().getComplemento());
            enderecoDTO.setCep(enderecoPessoa.getEndereco().getCep());
            enderecoDTO.setNumero(enderecoPessoa.getEndereco().getNumero());
            PessoaEnderecoDTO pessoaEnderecoDTO = new PessoaEnderecoDTO();
            pessoaEnderecoDTO.setEndereco(enderecoDTO);
            pessoaEnderecoDTO.setPrincipal(enderecoPessoa.getPrincipal());
            dto.getEnderecos().add(pessoaEnderecoDTO);
        }
    }

    private void createDocumentosDTO(PessoaDTO dto) {
        dto.getDocumentos().clear();
        this.getDocumentos().forEach(documento -> {
            PessoaDoc pessoaDoc = Optional.ofNullable(documento.getDoc()).orElse(new PessoaDoc());
            Documento documentoPessoa = Optional.ofNullable(pessoaDoc.getDocumento()).orElse(new Documento());
            DocumentoDTO documentoDTO = DocumentoDTO.builder().id(documentoPessoa.getId()).descricao(documentoPessoa.getDescricao()).build();
            PessoaDocDTO pessoaDocDTO = PessoaDocDTO.builder().documento(documentoDTO).dataEmissao(documento.getDoc().getDataEmissao()).dataValidade(documento.getDoc().getDataValidade()).numeroDocumento(documento.getDoc().getNumeroDocumento()).build();
            dto.getDocumentos().add(pessoaDocDTO);
        });
    }

    @Generated
    public String toString() {
        return "Pessoa(id=" + this.getId() + ", nome=" + this.getNome() + ", tipoPessoa=" + String.valueOf(this.getTipoPessoa()) + ", cnpjCpf=" + this.getCnpjCpf() + ", contribuinte=" + this.getContribuinte() + ", fornecedor=" + this.getFornecedor() + ", consorcio=" + this.getConsorcio() + ", pessoal=" + this.getPessoal() + ", protocolo=" + this.getProtocolo() + ", inativo=" + this.getInativo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pessoa)) {
            return false;
        }
        Pessoa other = (Pessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public void setIsServiceAccount(Boolean isServiceAccount) {
        this.isServiceAccount = isServiceAccount;
    }

    @Generated
    public Boolean getIsServiceAccount() {
        return this.isServiceAccount;
    }
}

