/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.EntityPublisher;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.unico.client.dto.PaisDTO;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;

@Entity
@Table(name="unico.pais")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
public class Pais
extends EloDomain<Long>
implements EntityPublisher<PaisDTO, Long> {
    public static final String DESCRICAO_BRASIL = "Brasil";
    public static final Pais PAIS_INVALIDO = Pais.create((Long)0L, (String)"INVALIDO");
    @Id
    @EloSequence
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotEmpty
    @Column(length=60)
    @Caption(value="Descri\u00e7\u00e3o")
    private String descricao;
    @Column(length=5)
    @Caption(value="C\u00f3digo Bacen")
    private String codigoBacen;

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getCodigoBacen() {
        return this.codigoBacen;
    }

    public void setCodigoBacen(String codigoBacen) {
        this.codigoBacen = codigoBacen;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Pais withId(Long id) {
        this.id = id;
        return this;
    }

    public static Pais create(Long id, String descricao) {
        Pais pais = new Pais();
        pais.setId(id);
        pais.setDescricao(descricao);
        return pais;
    }

    public String hashString() {
        return ReplicatorFacade.hashCodeString((String)this.descricao);
    }

    public PaisDTO convertToEvent() {
        PaisDTO paisDTO = new PaisDTO();
        paisDTO.setId(this.id);
        paisDTO.setDescricao(this.descricao);
        paisDTO.setCodigoBacen(this.codigoBacen);
        return paisDTO;
    }

    public Boolean isExterior() {
        if (Objects.isNull(this.descricao)) {
            return false;
        }
        return DESCRICAO_BRASIL.equalsIgnoreCase(this.descricao.trim());
    }

    @Generated
    public String toString() {
        return "Pais(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", codigoBacen=" + this.getCodigoBacen() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pais)) {
            return false;
        }
        Pais other = (Pais)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pais;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

