/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.TipoModulo;
import br.com.elotech.di.domain.support.EloDomain;
import java.net.InetAddress;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="unico.modulo")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
public class Modulo
extends EloDomain<Long> {
    private static final String ELOTECH_PATH = "\\elotech\\";
    @Id
    @Caption(value="C\u00f3digo")
    @Column(name="modulo")
    @NotNull
    private Long id;
    @Length(max=30)
    @Caption(value="Descri\u00e7\u00e3o")
    private @Length(max=30) String descricao;
    @Length(max=100)
    @Caption(value="Path")
    private @Length(max=100) String path;
    @Column(length=1)
    @Caption(value="Tipo M\u00f3dulo")
    private TipoModulo tipoModulo = TipoModulo.ESPECIFICO;
    @Caption(value="Controla Acesso Relat\u00f3rio")
    private Boolean controlaAcessoRelatorio = Boolean.FALSE;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Modulo withModulo(Long modulo) {
        this.id = modulo;
        return this;
    }

    public static Modulo of(Long id) {
        return new Modulo().withModulo(id);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public TipoModulo getTipoModulo() {
        return this.tipoModulo;
    }

    public void setTipoModulo(TipoModulo tipoModulo) {
        this.tipoModulo = tipoModulo;
    }

    public Boolean getControlaAcessoRelatorio() {
        return this.controlaAcessoRelatorio;
    }

    public void setControlaAcessoRelatorio(Boolean controlaAcessoRelatorio) {
        this.controlaAcessoRelatorio = controlaAcessoRelatorio;
    }

    public static String format(Long modulo) {
        return StringUtils.leftPad((String)modulo.toString(), (int)2, (char)'0');
    }

    public void definePathByModuloEnum() {
        if (!Objects.isNull(this.id)) {
            this.setPath(Modulo.getPathByModuloEnum((String)this.id.toString()));
        }
    }

    public static String getPathByModuloEnum(String modulo) {
        ModuloEnum moduloEnum = ModuloEnum.getByValue((String)modulo);
        return String.format("%s%s%s%s", "\\\\", InetAddress.getLocalHost().getHostName(), "\\elotech\\", moduloEnum.getPath());
    }

    @Generated
    public String toString() {
        return "Modulo(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", path=" + this.getPath() + ", tipoModulo=" + String.valueOf(this.getTipoModulo()) + ", controlaAcessoRelatorio=" + this.getControlaAcessoRelatorio() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Modulo)) {
            return false;
        }
        Modulo other = (Modulo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Modulo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

