/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.CalculatedModel;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.LocalidadeAtivo;
import br.com.elotech.di.domain.TipoLogradouro;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.EntityPublisher;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.di.validation.SkipBatch;
import br.com.elotech.unico.client.dto.LogradouroDTO;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.logradouro")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
public class Logradouro
extends EloDomain<Long>
implements EntityPublisher<LogradouroDTO, Long>,
LocalidadeAtivo {
    public static final Logradouro LOGRADOURO_INVALIDO = new Logradouro().withId(Long.valueOf(0L)).withDescricao("INVALIDO").withCidade(Cidade.CIDADE_INVALIDA);
    @Id
    @EloSequence
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotEmpty(groups={SkipBatch.class})
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o")
    private @NotEmpty(groups={SkipBatch.class}) @Length(max=100) String descricao;
    @ManyToOne
    @Caption(value="Cidade")
    @NotNull
    private Cidade cidade;
    @ManyToOne
    @Caption(value="Tipo Logradouro")
    private TipoLogradouro tipoLogradouro;
    @Caption(value="Inativo")
    private Boolean inativo = Boolean.FALSE;

    @CalculatedModel
    public String getTipoLogDesc() {
        if (this.tipoLogradouro != null) {
            return this.tipoLogradouro.getDescricao();
        }
        return null;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Cidade getCidade() {
        return this.cidade;
    }

    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    public TipoLogradouro getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public void setTipoLogradouro(TipoLogradouro tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    public Logradouro withId(Long id) {
        this.id = id;
        return this;
    }

    public Logradouro withDescricao(String descricao) {
        this.descricao = descricao;
        return this;
    }

    public Logradouro withCidade(Cidade cidade) {
        this.cidade = cidade;
        return this;
    }

    public Boolean getInativo() {
        return this.inativo;
    }

    public void setInativo(Boolean inativo) {
        this.inativo = inativo;
    }

    public String hashString() {
        return ReplicatorFacade.hashCodeEloEntity((EloEntity)this.getCidade()) + ReplicatorFacade.hashCodeString((String)this.getDescricao());
    }

    public LogradouroDTO convertToEvent() {
        LogradouroDTO logradouroDTO = new LogradouroDTO();
        logradouroDTO.setId(this.id);
        logradouroDTO.setDescricao(this.descricao);
        logradouroDTO.setInativo(this.inativo);
        if (Objects.nonNull(this.cidade)) {
            logradouroDTO.setCidade(this.cidade.convertToEvent());
        }
        return logradouroDTO;
    }

    @Generated
    public String toString() {
        return "Logradouro(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", cidade=" + String.valueOf(this.getCidade()) + ", tipoLogradouro=" + String.valueOf(this.getTipoLogradouro()) + ", inativo=" + this.getInativo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Logradouro)) {
            return false;
        }
        Logradouro other = (Logradouro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Logradouro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

