/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.ToModel;
import br.com.elotech.di.domain.VeiculoPublicacao;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.validation.SkipBatch;
import br.com.elotech.di.validation.SkipBatchValidation;
import java.time.LocalDate;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.leiatopublicacao")
@DynamicUpdate
@Audited
@SkipBatchValidation
public class LeiAtoPublicacao
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true)
    @Caption(value="C\u00f3digo")
    private Long id;
    @ManyToOne
    @Caption(value="Ve\u00edculo de Publica\u00e7\u00e3o")
    @NotNull
    @ToModel(of={"id", "descricao"})
    private VeiculoPublicacao veiculoPublicacao;
    @Caption(value="N\u00famero da edi\u00e7\u00e3o")
    private Long numeroEdicao;
    @Caption(value="Ano da edi\u00e7\u00e3o")
    @Max(value=3000L, groups={SkipBatch.class})
    @Min(value=1900L, groups={SkipBatch.class})
    private @Max(value=3000L, groups={SkipBatch.class}) @Min(value=1900L, groups={SkipBatch.class}) Long anoEdicao;
    @Caption(value="Data da Publica\u00e7\u00e3o")
    private LocalDate dataPublicacao;
    @Caption(value="Principal")
    private Boolean principal;
    @Caption(value="P\u00e1gina")
    @Length(max=50)
    private @Length(max=50) String pagina;
    @Valid
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="idarquivo")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="")
    private Arquivo arquivo;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setVeiculoPublicacao(VeiculoPublicacao veiculoPublicacao) {
        this.veiculoPublicacao = veiculoPublicacao;
    }

    public VeiculoPublicacao getVeiculoPublicacao() {
        return this.veiculoPublicacao;
    }

    public void setNumeroEdicao(Long numeroEdicao) {
        this.numeroEdicao = numeroEdicao;
    }

    public void setAnoEdicao(Long anoEdicao) {
        this.anoEdicao = anoEdicao;
    }

    public Long getNumeroEdicao() {
        return this.numeroEdicao;
    }

    public Long getAnoEdicao() {
        return this.anoEdicao;
    }

    public void setDataPublicacao(LocalDate dataPublicacao) {
        this.dataPublicacao = dataPublicacao;
    }

    public LocalDate getDataPublicacao() {
        return this.dataPublicacao;
    }

    public Boolean getPrincipal() {
        if (this.principal == null) {
            return false;
        }
        return this.principal;
    }

    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    public void setPagina(String pagina) {
        this.pagina = pagina;
    }

    public String getPagina() {
        return this.pagina;
    }

    public Arquivo getArquivo() {
        return this.arquivo;
    }

    public void setArquivo(Arquivo arquivo) {
        this.arquivo = arquivo;
    }

    @Generated
    public String toString() {
        return "LeiAtoPublicacao(id=" + this.getId() + ", numeroEdicao=" + this.getNumeroEdicao() + ", anoEdicao=" + this.getAnoEdicao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeiAtoPublicacao)) {
            return false;
        }
        LeiAtoPublicacao other = (LeiAtoPublicacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LeiAtoPublicacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

