/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.core.metamodel.annotation.ToModel;
import br.com.elotech.core.web.advice.JsonFilterFields;
import br.com.elotech.di.domain.AtoEsferaGoverno;
import br.com.elotech.di.domain.AtoSituacao;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.LeiAtoAlteracao;
import br.com.elotech.di.domain.LeiAtoArquivo;
import br.com.elotech.di.domain.LeiAtoAutores;
import br.com.elotech.di.domain.LeiAtoPublicacao;
import br.com.elotech.di.domain.Modulo;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.TipoLeiAssunto;
import br.com.elotech.di.domain.TipoLeiDocumento;
import br.com.elotech.di.domain.TipoLeiEscopo;
import br.com.elotech.di.domain.TipoLeiNatureza;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.EntityPublisher;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.di.validation.SkipBatch;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import br.com.elotech.unico.client.domain.TipoAbrangencia;
import br.com.elotech.unico.client.dto.LeiAtoDTO;
import br.com.elotech.unico.client.dto.PessoaDTO;
import br.com.elotech.unico.client.dto.TipoLeiDocumentoDTO;
import br.com.elotech.unico.client.dto.TipoLeiEscopoDTO;
import br.com.elotech.unico.client.dto.TipoLeiNaturezaDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Formula;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.leiato")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
@JsonFilterFields(of={"id", "numero", "ano", "modulo", "entidade.id", "entidade.nome", "entidade.tipo", "tipoLeiDocumento.id", "tipoLeiDocumento.codigo", "tipoLeiDocumento.descricao", "tipoLeiEscopo.id", "tipoLeiEscopo.codigo", "tipoLeiEscopo.descricao", "tipoLeiNatureza.id", "tipoLeiNatureza.codigo", "tipoLeiNatureza.descricao", "dataAto", "dataPublicacao", "dataCadastro", "dataGeracaoTC", "idTce", "numeroTce", "anoInicio", "pagina", "numeroEdicao", "numeroEdicao", "anoEdicao", "sumula", "mostraPortal", "mostraPessoal", "mostraReceita", "mostraDespesa", "valorSuplementar", "valorEspecial", "valorExtraordinario", "valorSuperavit", "valorSuperavitVinculado", "valorExcesso", "valorExcessoVinculado", "valorAnulacao", "valorOperacaoDeCredito", "valorSemDespCorrespondente", "percSuplementacao", "percOpCredaro", "percOpCredInt", "situacao.codigo", "situacao.descricao", "esferaGoverno.codigo", "esferaGoverno.descricao", "dataInicioVigencia", "dataFimVigencia", "leiAut.id", "leiAut.numero", "leiAut.ano", "arquivos.id", "arquivos.principal", "arquivos.arquivo.id", "arquivos.arquivo.nome", "arquivos.arquivo.dataCriacao", "arquivos.arquivo.mimeType", "arquivos.arquivo.fullPath", "arquivos.arquivo.metaDados", "publicacoes.id", "publicacoes.numeroEdicao", "publicacoes.anoEdicao", "publicacoes.principal", "publicacoes.pagina", "publicacoes.veiculoPublicacao.id", "publicacoes.dataPublicacao", "publicacoes.veiculoPublicacao.descricao", "publicacoes.arquivo.id", "publicacoes.arquivo.nome", "entidadeOrigem.id", "entidadeOrigem.identificacaoTCE", "entidadeOrigem.cnpj", "entidadeOrigem.nome", "atoPessoal", "descricaoVeiculoPublicacao", "alteracoes", "alteracoes.id", "alteracoes.dataVinculo", "alteracoes.descricao", "alteracoes.tipoAlteracao", "alteracoes.tipoAlteracao.id", "alteracoes.tipoAlteracao.descricao", "alteracoes.ato", "alteracoes.ato.id", "alteracoes.ato.numero", "tipoAbrangencia", "autores", "autores.id", "autores.autor", "autores.autor.id", "autores.autor.pessoa", "autores.autor.tipoCargo", "autores.autor.gestaoAdministrativa", "autores.autor.gestaoAdministrativa.id", "autores.autor.gestaoAdministrativa.observacao", "autores.autor.pessoa.nome", "tipoAbrangencia", "tipoLeiAssunto.id", "tipoLeiAssunto.codigo", "tipoLeiAssunto.descricao", "vincularEnteConsorciado", "enteConsorciado.id", "enteConsorciado.nome", "enteConsorciado.cnpjCpf", "enteConsorciado.formattedCnpjCpf", "enteConsorciado.tipoPessoa", "enteConsorciado.idTcePR"})
public class LeiAto
extends EloDomain<Long>
implements EntityPublisher<LeiAtoDTO, Long> {
    @Id
    @EloSequence
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotNull
    @Caption(value="N\u00famero Lei")
    private Long numero;
    @NotNull
    @Caption(value="Ano Lei")
    private Long ano;
    @ManyToOne
    @Caption(value="M\u00f3dulo")
    private Modulo modulo;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @Caption(value="Entidade")
    @ToModel(of={"id", "nome"})
    private Entidade entidade;
    @ManyToOne
    @Caption(value="Documento")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private TipoLeiDocumento tipoLeiDocumento;
    @ManyToOne
    @Caption(value="Escopo")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private TipoLeiEscopo tipoLeiEscopo;
    @NotNull
    @ManyToOne
    @Caption(value="Natureza")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private TipoLeiNatureza tipoLeiNatureza;
    @ManyToOne
    @Caption(value="Tipo Assunto")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private TipoLeiAssunto tipoLeiAssunto;
    @Caption(value="Data Ato")
    private LocalDate dataAto;
    @Caption(value="Data Publica\u00e7\u00e3o")
    private LocalDate dataPublicacao;
    @Caption(value="Data Cadastro")
    @NotNull(groups={SkipBatch.class})
    private LocalDate dataCadastro;
    @Caption(value="Data Gera\u00e7\u00e3o TC")
    private LocalDate dataGeracaoTC;
    @Caption(value="C\u00f3digo TCE")
    @EloSequence(applyOnMerge=true, schema="unico", sequenceName="gen_leiato_idtce#{entidade.id}")
    private Long idTce;
    @Caption(value="N\u00famero TCE")
    @Length(max=20)
    private @Length(max=20) String numeroTce;
    @Caption(value="Ano In\u00edcio")
    private Long anoInicio;
    @Length(max=50)
    @Caption(value="P\u00e1gina")
    private @Length(max=50) String pagina;
    @Caption(value="N\u00famero Edi\u00e7\u00e3o")
    private Long numeroEdicao;
    @Caption(value="Ano Edi\u00e7\u00e3o")
    private Long anoEdicao;
    @Length(max=4000)
    @Caption(value="S\u00famula")
    private @Length(max=4000) String sumula;
    @Caption(value="Mostrar no Portal?")
    private Boolean mostraPortal = Boolean.TRUE;
    @Caption(value="Mostrar na aba Pessoal?")
    private Boolean mostraPessoal = Boolean.FALSE;
    @Caption(value="Mostrar na aba Exec(Receita)?")
    private Boolean mostraReceita = Boolean.FALSE;
    @Caption(value="Mostrar na aba Exec(Despesa)?")
    private Boolean mostraDespesa = Boolean.FALSE;
    @Caption(value="Ato Pessoal")
    private Boolean atoPessoal = Boolean.FALSE;
    @Caption(value="Valor Suplementar")
    private BigDecimal valorSuplementar;
    @Caption(value="Valor Especial")
    private BigDecimal valorEspecial;
    @Caption(value="Valor Extraordin\u00e1rio")
    private BigDecimal valorExtraordinario;
    @Caption(value="Valor Super\u00e1vit")
    private BigDecimal valorSuperavit;
    @Caption(value="Valor Super\u00e1vit Vinculado")
    private BigDecimal valorSuperavitVinculado;
    @Caption(value="Valor Excesso")
    private BigDecimal valorExcesso;
    @Caption(value="Valor Excesso Vinculado")
    private BigDecimal valorExcessoVinculado;
    @Caption(value="Valor Anula\u00e7\u00e3o")
    private BigDecimal valorAnulacao;
    @Caption(value="Valor Opera\u00e7\u00e3o de Cr\u00e9dito")
    private BigDecimal valorOperacaoDeCredito;
    @Caption(value="Sem Despesa Correspondente")
    private BigDecimal valorSemDespCorrespondente;
    @Caption(value="Percentual Suplementa\u00e7\u00e3o")
    private BigDecimal percSuplementacao;
    @Caption(value="Percentual Op. Cr\u00e9dito")
    private BigDecimal percOpCredaro;
    @Caption(value="Percentual Op. Cr\u00e9ditos Interna")
    private BigDecimal percOpCredInt;
    @Caption(value="Situa\u00e7\u00e3o")
    @Column(length=1)
    private AtoSituacao situacao;
    @Caption(value="Esfera de Governo")
    @Column(length=1)
    private AtoEsferaGoverno esferaGoverno;
    @Caption(value="Data In\u00edcio Vig\u00eancia")
    private LocalDate dataInicioVigencia;
    @Caption(value="Data Fim Vig\u00eancia")
    private LocalDate dataFimVigencia;
    @ManyToOne
    @JoinColumn(name="leiAutorizativa")
    @ToModel(exclude={"leiAut", "arquivos", "publicacoes"})
    @Caption(value="Lei Autorizativa")
    private LeiAto leiAut;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="leiato", updatable=false, nullable=false)
    @Valid
    @Caption(value="Arquivos")
    @AuditJoinTable(name="unico.leiato_leiatoarquivo_aud")
    private final List<LeiAtoArquivo> arquivos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="leiato", updatable=false, nullable=false)
    @Valid
    @Caption(value="Publica\u00e7\u00f5es")
    @AuditJoinTable(name="unico.leiato_leiatopublicacao_aud")
    private final List<LeiAtoPublicacao> publicacoes = new ArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    @Caption(value="Entidade Origem")
    @ToModel(of={"id", "nome"})
    private Entidade entidadeOrigem;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="leiato", updatable=false, nullable=false)
    @AuditJoinTable(name="unico.leiato_leiatoalteracao_aud")
    private List<LeiAtoAlteracao> alteracoes = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="leiato", updatable=false, nullable=false)
    @Caption(value="Autores")
    private List<LeiAtoAutores> autores = new ArrayList();
    @NotAudited
    @MetaModelIgnore
    @Formula(value="(select vp.descricao from {SCHEMA_UNICO}.leiatopublicacao lap     inner join {SCHEMA_UNICO}.veiculopublicacao vp on vp.id = lap.veiculopublicacao    where lap.principal = 'S' and lap.leiato = id)")
    private String descricaoVeiculoPublicacao;
    @Caption(value="Abrang\u00eancia")
    @Enumerated(value=EnumType.STRING)
    @Column(name="tipoabrangencia")
    private TipoAbrangencia tipoAbrangencia = TipoAbrangencia.MUNICIPAL;
    @Caption(value="Vincular Ente Consorciado como Entidade Origem")
    private Boolean vincularEnteConsorciado = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY)
    @Caption(value="Ente Consorciado")
    @ToModel(of={"id", "nome", "cnpjCpf"})
    private Pessoa enteConsorciado;

    public String hashString() {
        TipoLeiDocumento tipoDoc = Optional.ofNullable(this.tipoLeiDocumento).orElse(new TipoLeiDocumento());
        return ReplicatorFacade.hashCodeEloEntity((EloEntity)this.entidade) + ReplicatorFacade.hashCodeLong((Long)this.numero) + ReplicatorFacade.hashCodeLong((Long)this.ano) + ReplicatorFacade.hashCodeEloEntity((EloEntity)this.tipoLeiEscopo) + ReplicatorFacade.hashCodeEloEntity((EloEntity)this.tipoLeiNatureza) + ReplicatorFacade.hashCodeLong((Long)tipoDoc.getId());
    }

    public LeiAto withId(Long id) {
        this.setId(id);
        return this;
    }

    public static LeiAto of(Long id) {
        return new LeiAto().withId(id);
    }

    public LeiAtoPublicacao getPublicacaoPrincipal() {
        return this.publicacoes.stream().filter(LeiAtoPublicacao::getPrincipal).findFirst().orElse(null);
    }

    public LeiAtoArquivo getArquivoPrincipal() {
        return this.arquivos.stream().filter(LeiAtoArquivo::getPrincipal).findFirst().orElse(null);
    }

    public LeiAto withLeiAut(LeiAto leiAto) {
        this.setLeiAut(leiAto);
        return this;
    }

    public LeiAto withTipoLeiDocumento(TipoLeiDocumento tipoLeiDocumento) {
        this.setTipoLeiDocumento(tipoLeiDocumento);
        return this;
    }

    public LeiAtoDTO convertToEvent() {
        LeiAtoDTO dto = new LeiAtoDTO();
        dto.setId(this.id);
        dto.setNumero(this.numero);
        dto.setAno(this.ano);
        dto.setDataCadastro(this.dataCadastro);
        dto.setDataAto(this.dataAto);
        dto.setEntidade((EntidadeDTO)Optional.ofNullable(this.entidade).map(e -> EntidadeDTO.builder().id(e.getId()).identificacaoTCE(e.getIdentificacaoTCE()).build()).orElse(null));
        dto.setEntidadeOrigem((EntidadeDTO)Optional.ofNullable(this.entidadeOrigem).map(eOrigem -> EntidadeDTO.builder().id(eOrigem.getId()).identificacaoTCE(eOrigem.getIdentificacaoTCE()).build()).orElse(null));
        dto.setValorSuplementar(this.valorSuplementar);
        dto.setValorEspecial(this.valorEspecial);
        dto.setValorExtraordinario(this.valorExtraordinario);
        dto.setValorSuperavit(this.valorSuperavit);
        dto.setValorSuperavitVinculado(this.valorSuperavitVinculado);
        dto.setValorExcesso(this.valorExcesso);
        dto.setValorExcessoVinculado(this.valorExcessoVinculado);
        dto.setValorAnulacao(this.valorAnulacao);
        dto.setValorOperacaoDeCredito(this.valorOperacaoDeCredito);
        dto.setValorSemDespCorrespondente(this.valorSemDespCorrespondente);
        dto.setSumula(this.sumula);
        dto.setMostraPortal(this.mostraPortal);
        dto.setDataInicioVigencia(this.dataInicioVigencia);
        dto.setDataFimVigencia(this.dataFimVigencia);
        dto.setIdTce(this.idTce);
        dto.setAtoPessoal(this.atoPessoal);
        dto.setVincularEnteConsorciado(this.vincularEnteConsorciado);
        dto.setEnteConsorciado((PessoaDTO)Optional.ofNullable(this.enteConsorciado).map(Pessoa::convertToEvent).orElse(null));
        this.convertTipoLeiEscopoDTO(dto, this.getTipoLeiEscopo());
        this.convertTipoLeiDocumentoDTO(dto, this.getTipoLeiDocumento());
        this.convertTipoLeiNaturezaDTO(dto, this.getTipoLeiNatureza());
        return dto;
    }

    private void convertTipoLeiEscopoDTO(LeiAtoDTO dto, TipoLeiEscopo tipoLeiEscopo) {
        if (Objects.nonNull(tipoLeiEscopo)) {
            TipoLeiEscopoDTO tipoLeiEscopoDTO = new TipoLeiEscopoDTO();
            tipoLeiEscopoDTO.setId(tipoLeiEscopo.getId());
            tipoLeiEscopoDTO.setDescricao(tipoLeiEscopo.getDescricao());
            tipoLeiEscopoDTO.setCodigo(tipoLeiEscopo.getCodigo());
            tipoLeiEscopoDTO.setPlurianual(tipoLeiEscopo.getPlurianual());
            dto.setTipoLeiEscopo(tipoLeiEscopoDTO);
        }
    }

    private void convertTipoLeiDocumentoDTO(LeiAtoDTO dto, TipoLeiDocumento tipoLeiDocumento) {
        if (Objects.nonNull(tipoLeiDocumento)) {
            TipoLeiDocumentoDTO tipoLeiDocumentoDTO = new TipoLeiDocumentoDTO();
            tipoLeiDocumentoDTO.setId(tipoLeiDocumento.getId());
            tipoLeiDocumentoDTO.setDescricao(tipoLeiDocumento.getDescricao());
            tipoLeiDocumentoDTO.setCodigo(tipoLeiDocumento.getCodigo());
            dto.setTipoLeiDocumento(tipoLeiDocumentoDTO);
        }
    }

    private void convertTipoLeiNaturezaDTO(LeiAtoDTO dto, TipoLeiNatureza tipoLeiNatureza) {
        if (Objects.nonNull(tipoLeiNatureza)) {
            TipoLeiNaturezaDTO tipoLeiNaturezaDTO = new TipoLeiNaturezaDTO();
            tipoLeiNaturezaDTO.setId(tipoLeiNatureza.getId());
            tipoLeiNaturezaDTO.setDescricao(tipoLeiNatureza.getDescricao());
            tipoLeiNaturezaDTO.setCodigo(tipoLeiNatureza.getCodigo());
            dto.setTipoLeiNatureza(tipoLeiNaturezaDTO);
        }
    }

    public void markArquivoPrincipalIfNoneExists() {
        if (this.arquivos.stream().noneMatch(LeiAtoArquivo::getPrincipal)) {
            this.arquivos.stream().findFirst().ifPresent(arq -> arq.setPrincipal(Boolean.valueOf(true)));
        }
    }

    public boolean hasChangesOnCloseDate(LeiAto other) {
        return !this.getDataCadastro().equals(other.getDataCadastro()) || !other.getHashString().equals(this.hashString());
    }

    @Generated
    public LeiAto() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getNumero() {
        return this.numero;
    }

    @Generated
    public Long getAno() {
        return this.ano;
    }

    @Generated
    public Modulo getModulo() {
        return this.modulo;
    }

    @Generated
    public Entidade getEntidade() {
        return this.entidade;
    }

    @Generated
    public TipoLeiDocumento getTipoLeiDocumento() {
        return this.tipoLeiDocumento;
    }

    @Generated
    public TipoLeiEscopo getTipoLeiEscopo() {
        return this.tipoLeiEscopo;
    }

    @Generated
    public TipoLeiNatureza getTipoLeiNatureza() {
        return this.tipoLeiNatureza;
    }

    @Generated
    public TipoLeiAssunto getTipoLeiAssunto() {
        return this.tipoLeiAssunto;
    }

    @Generated
    public LocalDate getDataAto() {
        return this.dataAto;
    }

    @Generated
    public LocalDate getDataPublicacao() {
        return this.dataPublicacao;
    }

    @Generated
    public LocalDate getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public LocalDate getDataGeracaoTC() {
        return this.dataGeracaoTC;
    }

    @Generated
    public Long getIdTce() {
        return this.idTce;
    }

    @Generated
    public String getNumeroTce() {
        return this.numeroTce;
    }

    @Generated
    public Long getAnoInicio() {
        return this.anoInicio;
    }

    @Generated
    public String getPagina() {
        return this.pagina;
    }

    @Generated
    public Long getNumeroEdicao() {
        return this.numeroEdicao;
    }

    @Generated
    public Long getAnoEdicao() {
        return this.anoEdicao;
    }

    @Generated
    public String getSumula() {
        return this.sumula;
    }

    @Generated
    public Boolean getMostraPortal() {
        return this.mostraPortal;
    }

    @Generated
    public Boolean getMostraPessoal() {
        return this.mostraPessoal;
    }

    @Generated
    public Boolean getMostraReceita() {
        return this.mostraReceita;
    }

    @Generated
    public Boolean getMostraDespesa() {
        return this.mostraDespesa;
    }

    @Generated
    public Boolean getAtoPessoal() {
        return this.atoPessoal;
    }

    @Generated
    public BigDecimal getValorSuplementar() {
        return this.valorSuplementar;
    }

    @Generated
    public BigDecimal getValorEspecial() {
        return this.valorEspecial;
    }

    @Generated
    public BigDecimal getValorExtraordinario() {
        return this.valorExtraordinario;
    }

    @Generated
    public BigDecimal getValorSuperavit() {
        return this.valorSuperavit;
    }

    @Generated
    public BigDecimal getValorSuperavitVinculado() {
        return this.valorSuperavitVinculado;
    }

    @Generated
    public BigDecimal getValorExcesso() {
        return this.valorExcesso;
    }

    @Generated
    public BigDecimal getValorExcessoVinculado() {
        return this.valorExcessoVinculado;
    }

    @Generated
    public BigDecimal getValorAnulacao() {
        return this.valorAnulacao;
    }

    @Generated
    public BigDecimal getValorOperacaoDeCredito() {
        return this.valorOperacaoDeCredito;
    }

    @Generated
    public BigDecimal getValorSemDespCorrespondente() {
        return this.valorSemDespCorrespondente;
    }

    @Generated
    public BigDecimal getPercSuplementacao() {
        return this.percSuplementacao;
    }

    @Generated
    public BigDecimal getPercOpCredaro() {
        return this.percOpCredaro;
    }

    @Generated
    public BigDecimal getPercOpCredInt() {
        return this.percOpCredInt;
    }

    @Generated
    public AtoSituacao getSituacao() {
        return this.situacao;
    }

    @Generated
    public AtoEsferaGoverno getEsferaGoverno() {
        return this.esferaGoverno;
    }

    @Generated
    public LocalDate getDataInicioVigencia() {
        return this.dataInicioVigencia;
    }

    @Generated
    public LocalDate getDataFimVigencia() {
        return this.dataFimVigencia;
    }

    @Generated
    public LeiAto getLeiAut() {
        return this.leiAut;
    }

    @Generated
    public List<LeiAtoArquivo> getArquivos() {
        return this.arquivos;
    }

    @Generated
    public List<LeiAtoPublicacao> getPublicacoes() {
        return this.publicacoes;
    }

    @Generated
    public Entidade getEntidadeOrigem() {
        return this.entidadeOrigem;
    }

    @Generated
    public List<LeiAtoAlteracao> getAlteracoes() {
        return this.alteracoes;
    }

    @Generated
    public List<LeiAtoAutores> getAutores() {
        return this.autores;
    }

    @Generated
    public String getDescricaoVeiculoPublicacao() {
        return this.descricaoVeiculoPublicacao;
    }

    @Generated
    public TipoAbrangencia getTipoAbrangencia() {
        return this.tipoAbrangencia;
    }

    @Generated
    public Boolean getVincularEnteConsorciado() {
        return this.vincularEnteConsorciado;
    }

    @Generated
    public Pessoa getEnteConsorciado() {
        return this.enteConsorciado;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Generated
    public void setAno(Long ano) {
        this.ano = ano;
    }

    @Generated
    public void setModulo(Modulo modulo) {
        this.modulo = modulo;
    }

    @Generated
    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setTipoLeiDocumento(TipoLeiDocumento tipoLeiDocumento) {
        this.tipoLeiDocumento = tipoLeiDocumento;
    }

    @Generated
    public void setTipoLeiEscopo(TipoLeiEscopo tipoLeiEscopo) {
        this.tipoLeiEscopo = tipoLeiEscopo;
    }

    @Generated
    public void setTipoLeiNatureza(TipoLeiNatureza tipoLeiNatureza) {
        this.tipoLeiNatureza = tipoLeiNatureza;
    }

    @Generated
    public void setTipoLeiAssunto(TipoLeiAssunto tipoLeiAssunto) {
        this.tipoLeiAssunto = tipoLeiAssunto;
    }

    @Generated
    public void setDataAto(LocalDate dataAto) {
        this.dataAto = dataAto;
    }

    @Generated
    public void setDataPublicacao(LocalDate dataPublicacao) {
        this.dataPublicacao = dataPublicacao;
    }

    @Generated
    public void setDataCadastro(LocalDate dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setDataGeracaoTC(LocalDate dataGeracaoTC) {
        this.dataGeracaoTC = dataGeracaoTC;
    }

    @Generated
    public void setIdTce(Long idTce) {
        this.idTce = idTce;
    }

    @Generated
    public void setNumeroTce(String numeroTce) {
        this.numeroTce = numeroTce;
    }

    @Generated
    public void setAnoInicio(Long anoInicio) {
        this.anoInicio = anoInicio;
    }

    @Generated
    public void setPagina(String pagina) {
        this.pagina = pagina;
    }

    @Generated
    public void setNumeroEdicao(Long numeroEdicao) {
        this.numeroEdicao = numeroEdicao;
    }

    @Generated
    public void setAnoEdicao(Long anoEdicao) {
        this.anoEdicao = anoEdicao;
    }

    @Generated
    public void setSumula(String sumula) {
        this.sumula = sumula;
    }

    @Generated
    public void setMostraPortal(Boolean mostraPortal) {
        this.mostraPortal = mostraPortal;
    }

    @Generated
    public void setMostraPessoal(Boolean mostraPessoal) {
        this.mostraPessoal = mostraPessoal;
    }

    @Generated
    public void setMostraReceita(Boolean mostraReceita) {
        this.mostraReceita = mostraReceita;
    }

    @Generated
    public void setMostraDespesa(Boolean mostraDespesa) {
        this.mostraDespesa = mostraDespesa;
    }

    @Generated
    public void setAtoPessoal(Boolean atoPessoal) {
        this.atoPessoal = atoPessoal;
    }

    @Generated
    public void setValorSuplementar(BigDecimal valorSuplementar) {
        this.valorSuplementar = valorSuplementar;
    }

    @Generated
    public void setValorEspecial(BigDecimal valorEspecial) {
        this.valorEspecial = valorEspecial;
    }

    @Generated
    public void setValorExtraordinario(BigDecimal valorExtraordinario) {
        this.valorExtraordinario = valorExtraordinario;
    }

    @Generated
    public void setValorSuperavit(BigDecimal valorSuperavit) {
        this.valorSuperavit = valorSuperavit;
    }

    @Generated
    public void setValorSuperavitVinculado(BigDecimal valorSuperavitVinculado) {
        this.valorSuperavitVinculado = valorSuperavitVinculado;
    }

    @Generated
    public void setValorExcesso(BigDecimal valorExcesso) {
        this.valorExcesso = valorExcesso;
    }

    @Generated
    public void setValorExcessoVinculado(BigDecimal valorExcessoVinculado) {
        this.valorExcessoVinculado = valorExcessoVinculado;
    }

    @Generated
    public void setValorAnulacao(BigDecimal valorAnulacao) {
        this.valorAnulacao = valorAnulacao;
    }

    @Generated
    public void setValorOperacaoDeCredito(BigDecimal valorOperacaoDeCredito) {
        this.valorOperacaoDeCredito = valorOperacaoDeCredito;
    }

    @Generated
    public void setValorSemDespCorrespondente(BigDecimal valorSemDespCorrespondente) {
        this.valorSemDespCorrespondente = valorSemDespCorrespondente;
    }

    @Generated
    public void setPercSuplementacao(BigDecimal percSuplementacao) {
        this.percSuplementacao = percSuplementacao;
    }

    @Generated
    public void setPercOpCredaro(BigDecimal percOpCredaro) {
        this.percOpCredaro = percOpCredaro;
    }

    @Generated
    public void setPercOpCredInt(BigDecimal percOpCredInt) {
        this.percOpCredInt = percOpCredInt;
    }

    @Generated
    public void setSituacao(AtoSituacao situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setEsferaGoverno(AtoEsferaGoverno esferaGoverno) {
        this.esferaGoverno = esferaGoverno;
    }

    @Generated
    public void setDataInicioVigencia(LocalDate dataInicioVigencia) {
        this.dataInicioVigencia = dataInicioVigencia;
    }

    @Generated
    public void setDataFimVigencia(LocalDate dataFimVigencia) {
        this.dataFimVigencia = dataFimVigencia;
    }

    @Generated
    public void setLeiAut(LeiAto leiAut) {
        this.leiAut = leiAut;
    }

    @Generated
    public void setEntidadeOrigem(Entidade entidadeOrigem) {
        this.entidadeOrigem = entidadeOrigem;
    }

    @Generated
    public void setAlteracoes(List<LeiAtoAlteracao> alteracoes) {
        this.alteracoes = alteracoes;
    }

    @Generated
    public void setAutores(List<LeiAtoAutores> autores) {
        this.autores = autores;
    }

    @Generated
    public void setDescricaoVeiculoPublicacao(String descricaoVeiculoPublicacao) {
        this.descricaoVeiculoPublicacao = descricaoVeiculoPublicacao;
    }

    @Generated
    public void setTipoAbrangencia(TipoAbrangencia tipoAbrangencia) {
        this.tipoAbrangencia = tipoAbrangencia;
    }

    @Generated
    public void setVincularEnteConsorciado(Boolean vincularEnteConsorciado) {
        this.vincularEnteConsorciado = vincularEnteConsorciado;
    }

    @Generated
    public void setEnteConsorciado(Pessoa enteConsorciado) {
        this.enteConsorciado = enteConsorciado;
    }

    @Generated
    public String toString() {
        return "LeiAto(id=" + this.getId() + ", numero=" + this.getNumero() + ", ano=" + this.getAno() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeiAto)) {
            return false;
        }
        LeiAto other = (LeiAto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LeiAto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

