/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.converter.FuncionalidadeConverter;
import br.com.elotech.di.domain.Campo;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.Modulo;
import br.com.elotech.unico.client.domain.FuncionalidadeCampo;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="grupocampo", schema="unico")
@DynamicUpdate
@Audited
public class GrupoCampo
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true)
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotBlank
    @Length(max=250)
    @Caption(value="Descri\u00e7\u00e3o")
    private @NotBlank @Length(max=250) String descricao;
    @NotNull
    @ManyToOne
    @JoinColumn(name="entidade_id")
    @Caption(value="Entidade")
    private Entidade entidade;
    @NotNull
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Ativo")
    private Boolean ativo = Boolean.TRUE;
    @NotNull
    @ManyToOne
    @JoinColumn(name="modulo_id")
    @Caption(value="M\u00f3dulo")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private Modulo modulo;
    @NotNull
    @Caption(value="Funcionalidade")
    @Convert(converter=FuncionalidadeConverter.class)
    @Enumerated(value=EnumType.STRING)
    private FuncionalidadeCampo funcionalidade;
    @OrderBy(value="ordem")
    @OneToMany(mappedBy="grupoCampo", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<Campo> campos = new ArrayList();

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Entidade getEntidade() {
        return this.entidade;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public Modulo getModulo() {
        return this.modulo;
    }

    @Generated
    public FuncionalidadeCampo getFuncionalidade() {
        return this.funcionalidade;
    }

    @Generated
    public List<Campo> getCampos() {
        return this.campos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setModulo(Modulo modulo) {
        this.modulo = modulo;
    }

    @Generated
    public void setFuncionalidade(FuncionalidadeCampo funcionalidade) {
        this.funcionalidade = funcionalidade;
    }

    @Generated
    public void setCampos(List<Campo> campos) {
        this.campos = campos;
    }
}

