/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.unico.client.domain.enums.Periodo;
import br.com.elotech.unico.client.domain.enums.TipoFeriado;
import java.time.LocalDate;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Formula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.feriado")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class Feriado
implements EloEntity<Long> {
    @Id
    @EloSequence
    @Caption(value="C\u00f3digo")
    private Long id;
    @Caption(value="Ano")
    private Long ano;
    @NotNull
    @Caption(value="Data do Feriado")
    private LocalDate dataFeriado;
    @Formula(value=" extract(day from dataFeriado) ")
    private int diaCalculado;
    @Formula(value=" extract(month from dataFeriado) ")
    private int mesCalculado;
    @NotEmpty
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o")
    private @NotEmpty @Length(max=100) String descricao;
    @Enumerated(value=EnumType.STRING)
    @Caption(value="Per\u00edodo")
    private Periodo periodo = Periodo.INTEGRAL;
    @Enumerated(value=EnumType.STRING)
    @Caption(value="Tipo Feriado")
    private TipoFeriado tipoFeriado;
    @ManyToOne
    @JoinColumn(name="cidade")
    @Caption(value="Cidade")
    private Cidade cidade;

    @Generated
    public Feriado() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getAno() {
        return this.ano;
    }

    @Generated
    public LocalDate getDataFeriado() {
        return this.dataFeriado;
    }

    @Generated
    public int getDiaCalculado() {
        return this.diaCalculado;
    }

    @Generated
    public int getMesCalculado() {
        return this.mesCalculado;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Periodo getPeriodo() {
        return this.periodo;
    }

    @Generated
    public TipoFeriado getTipoFeriado() {
        return this.tipoFeriado;
    }

    @Generated
    public Cidade getCidade() {
        return this.cidade;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setAno(Long ano) {
        this.ano = ano;
    }

    @Generated
    public void setDataFeriado(LocalDate dataFeriado) {
        this.dataFeriado = dataFeriado;
    }

    @Generated
    public void setDiaCalculado(int diaCalculado) {
        this.diaCalculado = diaCalculado;
    }

    @Generated
    public void setMesCalculado(int mesCalculado) {
        this.mesCalculado = mesCalculado;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setPeriodo(Periodo periodo) {
        this.periodo = periodo;
    }

    @Generated
    public void setTipoFeriado(TipoFeriado tipoFeriado) {
        this.tipoFeriado = tipoFeriado;
    }

    @Generated
    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    @Generated
    public String toString() {
        return "Feriado(id=" + this.getId() + ", ano=" + this.getAno() + ", dataFeriado=" + String.valueOf(this.getDataFeriado()) + ", diaCalculado=" + this.getDiaCalculado() + ", mesCalculado=" + this.getMesCalculado() + ", descricao=" + this.getDescricao() + ", periodo=" + String.valueOf(this.getPeriodo()) + ", tipoFeriado=" + String.valueOf(this.getTipoFeriado()) + ", cidade=" + String.valueOf(this.getCidade()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Feriado)) {
            return false;
        }
        Feriado other = (Feriado)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Feriado;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

