/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.caelum.stella.bean.validation.CNPJ;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.enumerable.common.EntidadeTipo;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.web.advice.JsonFilterFields;
import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Cnae;
import br.com.elotech.di.domain.ContribuicaoPrevidenciaria;
import br.com.elotech.di.domain.EntidadeAreaAtuacao;
import br.com.elotech.di.domain.EntidadeCertificado;
import br.com.elotech.di.domain.FundoPrevidenciaSocial;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.PoderOrgaoContabil;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.EntityPublisher;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.di.validation.SkipBatch;
import br.com.elotech.unico.client.dto.BairroDTO;
import br.com.elotech.unico.client.dto.CidadeDTO;
import br.com.elotech.unico.client.dto.EntidadeDTO;
import br.com.elotech.unico.client.dto.LogradouroDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Generated;
import org.apache.commons.lang.BooleanUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;

@Entity
@Table(name="unico.entidade")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
@JsonFilterFields(of={"id", "nome", "cnpj", "ativo", "cidade.id", "cidade.descricao", "cidade.uf.id", "cidade.uf.sigla", "logradouro.id", "logradouro.descricao", "bairro.id", "bairro.descricao", "complemento", "numero", "cep", "entidadePrincipal", "tipo", "entidadeConsole", "brasao", "telefone", "identificacaoTCE", "carimboCarneCorreios", "percentualIsencaoFilantropica", "clienteElotech", "codAudesp", "codMunicAudesp", "email", "contribuicaoPrevidenciaria", "fundoPrevidenciaSocial", "poderOrgaoContabil", "mscCodigoSiconfi", "regimePrevidencia", "lote", "site", "funcionamento", "condominio", "distrito", "cnae.id", "cnae.codigo", "cnae.descricao", "certificado", "certificado.nome", "certificado.senha", "certificado.arquivo", "certificado.arquivo.id", "certificado.arquivo.nome", "entePublicoDireitoPrivado", "areasAtuacao", "areasAtuacao.id", "areasAtuacao.areaAtuacao.codigo", "areasAtuacao.areaAtuacao.descricao", "areasAtuacao.naturezaJuridica.codigo", "areasAtuacao.naturezaJuridica.descricao", "areasAtuacao.dataCadastro", "areasAtuacao.ativo", "areasAtuacao.dataDesativacao", "areasAtuacao.motivoDesativacao", "unidadeGestora", "unidadeAdministrativa"})
public class Entidade
extends EloDomain<Long>
implements EntityPublisher<EntidadeDTO, Long> {
    @Id
    @EloSequence
    @Caption(value="C\u00f3digo")
    private Long id;
    @Caption(value="Nome")
    @Column(length=100)
    @NotBlank
    private String nome;
    @Caption(value="Cnpj")
    @Column(length=20)
    @CNPJ(groups={SkipBatch.class})
    private String cnpj;
    @Caption(value="Ativo")
    private Boolean ativo = Boolean.TRUE;
    @ManyToOne
    @Caption(value="Cidade")
    private Cidade cidade;
    @ManyToOne
    @Caption(value="Logradouro")
    private Logradouro logradouro;
    @ManyToOne
    @Caption(value="Bairro")
    private Bairro bairro;
    @Caption(value="Complemento")
    @Column(length=60)
    private String complemento;
    @Caption(value="N\u00famero")
    @Column(length=10)
    private String numero;
    @Caption(value="Cep")
    @Column(length=10)
    private String cep;
    @Caption(value="Principal")
    @NotNull
    private Boolean entidadePrincipal = Boolean.FALSE;
    @Caption(value="Tipo")
    @Column(name="tipoentidade")
    @NotNull
    private EntidadeTipo tipo = EntidadeTipo.DEFAULT;
    @Caption(value="Entidade Console")
    @Column(name="entidadeconsole")
    @Type(type="uuid-char")
    private UUID entidadeConsole;
    @Caption(value="Bras\u00e3o")
    @NotAudited
    @Size(max=102400, groups={SkipBatch.class}, message="excede o tamanho permitido de 100KB.")
    private @Size(max=102400, groups={SkipBatch.class}, message="excede o tamanho permitido de 100KB.") byte[] brasao;
    @Caption(value="Telefone")
    @Column(length=20)
    private String telefone;
    @Caption(value="Identifica\u00e7\u00e3o TCE")
    @Column(length=10)
    private String identificacaoTCE;
    @Caption(value="Carimbo Carn\u00ea Correios")
    @NotAudited
    private byte[] carimboCarneCorreios;
    @Caption(value="Percentual Isen\u00e7\u00e3o Filantr\u00f3pica")
    private BigDecimal percentualIsencaoFilantropica;
    @Caption(value="Cliente Elotech")
    private Boolean clienteElotech = Boolean.TRUE;
    @Caption(value="C\u00f3digo Audesp")
    private Long codAudesp;
    @Caption(value="C\u00f3digo Munic\u00edpio Audesp")
    private Long codMunicAudesp;
    @Column(length=60)
    private String email;
    @Column(name="GPS")
    private ContribuicaoPrevidenciaria contribuicaoPrevidenciaria;
    @Column(name="FPAS")
    private FundoPrevidenciaSocial fundoPrevidenciaSocial;
    @Column(name="MSCPODERORGAO")
    private PoderOrgaoContabil poderOrgaoContabil;
    @Column(name="MSCCODIGOSICONFI", length=10)
    private String mscCodigoSiconfi;
    @Caption(value="Regime Previd\u00eancia")
    @Column(name="regimeprevidencia", length=15)
    private String regimePrevidencia;
    @Caption(value="Lote")
    @Column(name="lote", length=50)
    private String lote;
    @Caption(value="Site")
    @Column(name="site", length=300)
    private String site;
    @Caption(value="Funcionamento")
    @Column(name="funcionamento", length=200)
    private String funcionamento;
    @Caption(value="Condom\u00ednio")
    @Column(name="condominio", length=50)
    private String condominio;
    @Caption(value="Distrito")
    @Column(name="distrito", length=100)
    private String distrito;
    @ManyToOne
    private Cnae cnae;
    @Embedded
    @Caption(value="Certificado")
    private EntidadeCertificado certificado = new EntidadeCertificado();
    @NotNull
    @Caption(value="Ente P\u00fablico de Direito Privado")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean entePublicoDireitoPrivado = Boolean.FALSE;
    @Caption(value="\u00c1reas de Atua\u00e7\u00e3o")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="id_entidade", updatable=false, nullable=false)
    @NotAudited
    private List<EntidadeAreaAtuacao> areasAtuacao = new ArrayList();
    @Caption(value="Unidade Gestora")
    @Column(name="unidadegestora")
    private Integer unidadeGestora;
    @Caption(value="Unidade Administrativa")
    @Column(name="unidadeadministrativa")
    private Integer unidadeAdministrativa;

    public static Entidade of(Long id) {
        Entidade entidade = new Entidade();
        entidade.setId(id);
        return entidade;
    }

    public String hashString() {
        return ReplicatorFacade.hashCodeString((String)this.nome);
    }

    public String getLote() {
        return this.lote;
    }

    public void setLote(String lote) {
        this.lote = lote;
    }

    public String getSite() {
        return this.site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public String getFuncionamento() {
        return this.funcionamento;
    }

    public void setFuncionamento(String funcionamento) {
        this.funcionamento = funcionamento;
    }

    public String getCondominio() {
        return this.condominio;
    }

    public void setCondominio(String condominio) {
        this.condominio = condominio;
    }

    public String getDistrito() {
        return this.distrito;
    }

    public void setDistrito(String distrito) {
        this.distrito = distrito;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PoderOrgaoContabil getPoderOrgaoContabil() {
        return this.poderOrgaoContabil;
    }

    public void setPoderOrgaoContabil(PoderOrgaoContabil poderOrgaoContabil) {
        this.poderOrgaoContabil = poderOrgaoContabil;
    }

    public String getMscCodigoSiconfi() {
        return this.mscCodigoSiconfi;
    }

    public void setMscCodigoSiconfi(String mscCodigoSiconfi) {
        this.mscCodigoSiconfi = mscCodigoSiconfi;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public Cidade getCidade() {
        return this.cidade;
    }

    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    public Logradouro getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(Logradouro logradouro) {
        this.logradouro = logradouro;
    }

    public Bairro getBairro() {
        return this.bairro;
    }

    public void setBairro(Bairro bairro) {
        this.bairro = bairro;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public Boolean getEntidadePrincipal() {
        return this.entidadePrincipal;
    }

    public void setEntidadePrincipal(Boolean entidadePrincipal) {
        this.entidadePrincipal = entidadePrincipal;
    }

    public EntidadeTipo getTipo() {
        return this.tipo;
    }

    public void setTipo(EntidadeTipo tipo) {
        this.tipo = tipo;
    }

    public byte[] getBrasao() {
        return this.brasao;
    }

    public void setBrasao(byte[] brasao) {
        this.brasao = brasao;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public String getIdentificacaoTCE() {
        return this.identificacaoTCE;
    }

    public void setIdentificacaoTCE(String identificacaoTCE) {
        this.identificacaoTCE = identificacaoTCE;
    }

    public byte[] getCarimboCarneCorreios() {
        return this.carimboCarneCorreios;
    }

    public void setCarimboCarneCorreios(byte[] carimboCarneCorreios) {
        this.carimboCarneCorreios = carimboCarneCorreios;
    }

    public BigDecimal getPercentualIsencaoFilantropica() {
        return this.percentualIsencaoFilantropica;
    }

    public void setPercentualIsencaoFilantropica(BigDecimal percentualIsencaoFilantropica) {
        this.percentualIsencaoFilantropica = percentualIsencaoFilantropica;
    }

    public Boolean getClienteElotech() {
        return this.clienteElotech;
    }

    public void setClienteElotech(Boolean clienteElotech) {
        this.clienteElotech = clienteElotech;
    }

    public Long getCodAudesp() {
        return this.codAudesp;
    }

    public void setCodAudesp(Long codAudesp) {
        this.codAudesp = codAudesp;
    }

    public Long getCodMunicAudesp() {
        return this.codMunicAudesp;
    }

    public void setCodMunicAudesp(Long codMunicAudesp) {
        this.codMunicAudesp = codMunicAudesp;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public ContribuicaoPrevidenciaria getContribuicaoPrevidenciaria() {
        return this.contribuicaoPrevidenciaria;
    }

    public void setContribuicaoPrevidenciaria(ContribuicaoPrevidenciaria contribuicaoPrevidenciaria) {
        this.contribuicaoPrevidenciaria = contribuicaoPrevidenciaria;
    }

    public FundoPrevidenciaSocial getFundoPrevidenciaSocial() {
        return this.fundoPrevidenciaSocial;
    }

    public void setFundoPrevidenciaSocial(FundoPrevidenciaSocial fundoPrevidenciaSocial) {
        this.fundoPrevidenciaSocial = fundoPrevidenciaSocial;
    }

    public Cnae getCnae() {
        return this.cnae;
    }

    public void setCnae(Cnae cnae) {
        this.cnae = cnae;
    }

    public String getRegimePrevidencia() {
        return this.regimePrevidencia;
    }

    public void setRegimePrevidencia(String regimePrevidencia) {
        this.regimePrevidencia = regimePrevidencia;
    }

    public Entidade withId(Long id) {
        this.id = id;
        return this;
    }

    @Transient
    public boolean isEntidadePrincipal() {
        return BooleanUtils.isTrue((Boolean)this.entidadePrincipal);
    }

    public UUID getEntidadeConsole() {
        return this.entidadeConsole;
    }

    public void setEntidadeConsole(UUID entidadeConsole) {
        this.entidadeConsole = entidadeConsole;
    }

    public String getSiglaUF() {
        return Optional.ofNullable(this.cidade).map(Cidade::getUf).map(UF::getSigla).orElse("");
    }

    public EntidadeCertificado getCertificado() {
        return this.certificado;
    }

    public void setCertificado(EntidadeCertificado certificado) {
        this.certificado = certificado;
    }

    public void setEntePublicoDireitoPrivado(Boolean entePublicoDireitoPrivado) {
        this.entePublicoDireitoPrivado = entePublicoDireitoPrivado;
    }

    public Boolean getEntePublicoDireitoPrivado() {
        return this.entePublicoDireitoPrivado;
    }

    public Boolean getAtivo() {
        return BooleanUtils.isTrue((Boolean)this.ativo);
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public EntidadeDTO convertToEvent() {
        return EntidadeDTO.builder().id(this.id).nome(this.nome).cnpj(this.cnpj).cidade((CidadeDTO)Optional.ofNullable(this.cidade).map(Cidade::convertToEvent).orElse(null)).entidadePrincipal(this.entidadePrincipal).tipo(this.tipo).brasao(this.brasao).entidadeConsole(this.entidadeConsole).identificacaoTCE(this.identificacaoTCE).poderOrgaoContabil(Optional.ofNullable(this.poderOrgaoContabil).map(PoderOrgaoContabil::getValue).orElse("")).mscCodigoSiconfi(this.mscCodigoSiconfi).logradouro((LogradouroDTO)Optional.ofNullable(this.logradouro).map(Logradouro::convertToEvent).orElse(null)).numero(this.numero).bairro((BairroDTO)Optional.ofNullable(this.bairro).map(Bairro::convertToEvent).orElse(null)).complemento(this.complemento).cep(this.cep).telefone(this.telefone).email(this.email).entePublicoDireitoPrivado(this.entePublicoDireitoPrivado).ativo(this.ativo).build();
    }

    @Generated
    public List<EntidadeAreaAtuacao> getAreasAtuacao() {
        return this.areasAtuacao;
    }

    @Generated
    public Integer getUnidadeGestora() {
        return this.unidadeGestora;
    }

    @Generated
    public Integer getUnidadeAdministrativa() {
        return this.unidadeAdministrativa;
    }

    @Generated
    public void setAreasAtuacao(List<EntidadeAreaAtuacao> areasAtuacao) {
        this.areasAtuacao = areasAtuacao;
    }

    @Generated
    public void setUnidadeGestora(Integer unidadeGestora) {
        this.unidadeGestora = unidadeGestora;
    }

    @Generated
    public void setUnidadeAdministrativa(Integer unidadeAdministrativa) {
        this.unidadeAdministrativa = unidadeAdministrativa;
    }

    @Generated
    public String toString() {
        return "Entidade(id=" + this.getId() + ", nome=" + this.getNome() + ", cnpj=" + this.getCnpj() + ", ativo=" + this.getAtivo() + ", cidade=" + String.valueOf(this.getCidade()) + ", logradouro=" + String.valueOf(this.getLogradouro()) + ", bairro=" + String.valueOf(this.getBairro()) + ", complemento=" + this.getComplemento() + ", numero=" + this.getNumero() + ", cep=" + this.getCep() + ", entidadePrincipal=" + this.getEntidadePrincipal() + ", tipo=" + String.valueOf(this.getTipo()) + ", entidadeConsole=" + String.valueOf(this.getEntidadeConsole()) + ", telefone=" + this.getTelefone() + ", identificacaoTCE=" + this.getIdentificacaoTCE() + ", percentualIsencaoFilantropica=" + String.valueOf(this.getPercentualIsencaoFilantropica()) + ", clienteElotech=" + this.getClienteElotech() + ", codAudesp=" + this.getCodAudesp() + ", codMunicAudesp=" + this.getCodMunicAudesp() + ", email=" + this.getEmail() + ", contribuicaoPrevidenciaria=" + String.valueOf(this.getContribuicaoPrevidenciaria()) + ", fundoPrevidenciaSocial=" + String.valueOf(this.getFundoPrevidenciaSocial()) + ", poderOrgaoContabil=" + String.valueOf(this.getPoderOrgaoContabil()) + ", mscCodigoSiconfi=" + this.getMscCodigoSiconfi() + ", regimePrevidencia=" + this.getRegimePrevidencia() + ", lote=" + this.getLote() + ", site=" + this.getSite() + ", funcionamento=" + this.getFuncionamento() + ", condominio=" + this.getCondominio() + ", distrito=" + this.getDistrito() + ", cnae=" + String.valueOf(this.getCnae()) + ", certificado=" + String.valueOf(this.getCertificado()) + ", entePublicoDireitoPrivado=" + this.getEntePublicoDireitoPrivado() + ", areasAtuacao=" + String.valueOf(this.getAreasAtuacao()) + ", unidadeGestora=" + this.getUnidadeGestora() + ", unidadeAdministrativa=" + this.getUnidadeAdministrativa() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entidade)) {
            return false;
        }
        Entidade other = (Entidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Entidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

