/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.converter.TipoDocumentoConverter;
import br.com.elotech.di.domain.ClassificacaoDocumento;
import br.com.elotech.di.domain.DocumentoApresentadoPor;
import br.com.elotech.di.domain.TipoDocumento;
import br.com.elotech.di.domain.support.EloDomain;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.documento")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
public class Documento
extends EloDomain<Long> {
    @Id
    @Caption(value="C\u00f3digo")
    @EloSequence(applyOnMerge=true)
    private Long id;
    @NotNull
    @Caption(value="Tipo Documento")
    @Convert(converter=TipoDocumentoConverter.class)
    private TipoDocumento tipoDocumento;
    @Length(max=4000)
    @Caption(value="Descri\u00e7\u00e3o")
    @NotNull
    private @Length(max=4000) @NotNull String descricao;
    @Caption(value="Possui Validade")
    private Boolean possuiValidade = Boolean.TRUE;
    @Caption(value="Obrigat\u00f3rio Certid\u00e3o")
    private Boolean obrigatorioCertidao = Boolean.FALSE;
    @Caption(value="Apresentado Por")
    @Column(length=2)
    private DocumentoApresentadoPor apresentadoPor;
    @Caption(value="Classifica\u00e7\u00e3o")
    @Column(length=2)
    private ClassificacaoDocumento classificacao;
    @Caption(value="C\u00f3digo TCE.")
    private Long codigoTce;
    @Caption(value="Ativo")
    private Boolean ativo = Boolean.TRUE;

    public TipoDocumento getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(TipoDocumento tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    public Boolean getObrigatorioCertidao() {
        return this.obrigatorioCertidao;
    }

    public void setObrigatorioCertidao(Boolean obrigatorioCertidao) {
        this.obrigatorioCertidao = obrigatorioCertidao;
    }

    public ClassificacaoDocumento getClassificacao() {
        return this.classificacao;
    }

    public void setClassificacao(ClassificacaoDocumento classificacao) {
        this.classificacao = classificacao;
    }

    public Long getCodigoTce() {
        return this.codigoTce;
    }

    public void setCodigoTce(Long codigoTce) {
        this.codigoTce = codigoTce;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public DocumentoApresentadoPor getApresentadoPor() {
        return this.apresentadoPor;
    }

    public void setApresentadoPor(DocumentoApresentadoPor apresentadoPor) {
        this.apresentadoPor = apresentadoPor;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getPossuiValidade() {
        return this.possuiValidade;
    }

    public void setPossuiValidade(Boolean possuiValidade) {
        this.possuiValidade = possuiValidade;
    }

    public Documento withTipoDocumento(TipoDocumento tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
        return this;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public static Documento of(Long id) {
        Documento documento = new Documento();
        documento.setId(id);
        return documento;
    }

    @Generated
    public String toString() {
        return "Documento(id=" + this.getId() + ", tipoDocumento=" + String.valueOf(this.getTipoDocumento()) + ", descricao=" + this.getDescricao() + ", possuiValidade=" + this.getPossuiValidade() + ", obrigatorioCertidao=" + this.getObrigatorioCertidao() + ", apresentadoPor=" + String.valueOf(this.getApresentadoPor()) + ", classificacao=" + String.valueOf(this.getClassificacao()) + ", codigoTce=" + this.getCodigoTce() + ", ativo=" + this.getAtivo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Documento)) {
            return false;
        }
        Documento other = (Documento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Documento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

