/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.di.domain.CustomReportDatasource;
import br.com.elotech.fluent.dataset.ReportDatasetDefinition;
import br.com.elotech.fluent.dataset.ReportDatasets;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class CustomReportDatasourceBuilder {
    private final List<ReportDatasetDefinition> datasets = new ArrayList();
    private final Set<ParamLoader> parameters = new HashSet();

    public CustomReportDatasourceBuilder add(String name, ReportDataLoader<?> loader) {
        return this.add(name, name, loader);
    }

    public CustomReportDatasourceBuilder add(String name, String subreportName, ReportDataLoader<?> loader) {
        this.datasets.add(ReportDatasetDefinition.builder().tableName(name).subreportName(subreportName).loader(loader).build());
        return this;
    }

    public CustomReportDatasourceBuilder params(ParamLoader loader) {
        this.parameters.add(loader);
        return this;
    }

    public CustomReportDatasource build() {
        if (this.datasets.isEmpty()) {
            throw new IllegalStateException("Datasets must not be null");
        }
        ReportDatasets reportDatasets = new ReportDatasets();
        this.datasets.forEach(dataset -> reportDatasets.add(dataset.getTableName(), dataset.getSubreportName(), dataset.getLoader().load()));
        Set loadedParams = this.parameters.stream().flatMap(l -> l.load(reportDatasets).stream()).filter(Objects::nonNull).collect(Collectors.toSet());
        return new CustomReportDatasource(reportDatasets, loadedParams);
    }

    public CustomReportDatasourceBuilder param(Param param) {
        return this.params(x -> Sets.newHashSet((Object[])new Param[]{param}));
    }

    @Generated
    public List<ReportDatasetDefinition> getDatasets() {
        return this.datasets;
    }

    @Generated
    public Set<ParamLoader> getParameters() {
        return this.parameters;
    }
}

