/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.json.EloFilterable;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.validation.SkipBatch;
import br.com.elotech.unico.client.dto.ContatoDTO;
import java.time.LocalDate;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

public class Contato
implements EloFilterable {
    private static final int MAX_NOME_SIZE = 60;
    @Caption(value="Nome")
    @Length(max=60)
    @NotBlank(groups={SkipBatch.class})
    private @Length(max=60) @NotBlank(groups={SkipBatch.class}) String nome;
    @Caption(value="Fone Residencial")
    @Length(max=20)
    private @Length(max=20) String telefoneResidencial;
    @Caption(value="Fone Comercial")
    @Length(max=20)
    private @Length(max=20) String telefoneComercial;
    @Caption(value="Fone Fax")
    @Length(max=20)
    private @Length(max=20) String telefoneFax;
    @Caption(value="Celular")
    @Length(max=20)
    private @Length(max=20) String telefoneCelular;
    @Caption(value="E-Mail")
    @Length(max=100)
    @Email(groups={SkipBatch.class})
    private @Length(max=100) @Email(groups={SkipBatch.class}) String email;
    @Caption(value="Home Page")
    @Length(max=100)
    private @Length(max=100) String homePage;
    @Caption(value="CPF")
    @Length(max=11)
    private @Length(max=11) String cpf;
    @Caption(value="Representante Legal")
    private Boolean representanteLegal = Boolean.FALSE;
    @Caption(value="Representante")
    private Long representante;
    @Caption(value="RG")
    @Length(max=20)
    private @Length(max=20) String rg;
    @Caption(value="Org\u00e3o Emissor")
    @Length(max=20)
    private @Length(max=20) String orgaoEmissor;
    @Caption(value="Data Junta Comercial")
    private LocalDate dataJuntaComercial;
    @Caption(value="Brasileiro")
    private Boolean brasileiro = Boolean.TRUE;

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome != null && nome.length() > 60 ? nome.substring(0, 59) : nome;
    }

    public String getTelefonePrincipal() {
        if (this.getTelefoneComercial() != null) {
            return this.getTelefoneComercial();
        }
        if (this.getTelefoneCelular() != null) {
            return this.getTelefoneCelular();
        }
        if (this.getTelefoneResidencial() != null) {
            return this.getTelefoneResidencial();
        }
        return null;
    }

    public ContatoDTO getContatoDTO() {
        ContatoDTO contatoDTO = new ContatoDTO();
        contatoDTO.setNome(this.nome);
        contatoDTO.setEmail(this.email);
        contatoDTO.setHomePage(this.homePage);
        contatoDTO.setTelefoneCelular(this.telefoneCelular);
        contatoDTO.setTelefoneComercial(this.telefoneComercial);
        contatoDTO.setTelefoneFax(this.telefoneFax);
        contatoDTO.setTelefoneResidencial(this.telefoneResidencial);
        contatoDTO.setCpf(this.cpf);
        return contatoDTO;
    }

    @Generated
    public String getTelefoneResidencial() {
        return this.telefoneResidencial;
    }

    @Generated
    public String getTelefoneComercial() {
        return this.telefoneComercial;
    }

    @Generated
    public String getTelefoneFax() {
        return this.telefoneFax;
    }

    @Generated
    public String getTelefoneCelular() {
        return this.telefoneCelular;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getHomePage() {
        return this.homePage;
    }

    @Generated
    public String getCpf() {
        return this.cpf;
    }

    @Generated
    public Boolean getRepresentanteLegal() {
        return this.representanteLegal;
    }

    @Generated
    public Long getRepresentante() {
        return this.representante;
    }

    @Generated
    public String getRg() {
        return this.rg;
    }

    @Generated
    public String getOrgaoEmissor() {
        return this.orgaoEmissor;
    }

    @Generated
    public LocalDate getDataJuntaComercial() {
        return this.dataJuntaComercial;
    }

    @Generated
    public Boolean getBrasileiro() {
        return this.brasileiro;
    }

    @Generated
    public void setTelefoneResidencial(String telefoneResidencial) {
        this.telefoneResidencial = telefoneResidencial;
    }

    @Generated
    public void setTelefoneComercial(String telefoneComercial) {
        this.telefoneComercial = telefoneComercial;
    }

    @Generated
    public void setTelefoneFax(String telefoneFax) {
        this.telefoneFax = telefoneFax;
    }

    @Generated
    public void setTelefoneCelular(String telefoneCelular) {
        this.telefoneCelular = telefoneCelular;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setHomePage(String homePage) {
        this.homePage = homePage;
    }

    @Generated
    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    @Generated
    public void setRepresentanteLegal(Boolean representanteLegal) {
        this.representanteLegal = representanteLegal;
    }

    @Generated
    public void setRepresentante(Long representante) {
        this.representante = representante;
    }

    @Generated
    public void setRg(String rg) {
        this.rg = rg;
    }

    @Generated
    public void setOrgaoEmissor(String orgaoEmissor) {
        this.orgaoEmissor = orgaoEmissor;
    }

    @Generated
    public void setDataJuntaComercial(LocalDate dataJuntaComercial) {
        this.dataJuntaComercial = dataJuntaComercial;
    }

    @Generated
    public void setBrasileiro(Boolean brasileiro) {
        this.brasileiro = brasileiro;
    }

    @Generated
    public String toString() {
        return "Contato(nome=" + this.getNome() + ", telefoneResidencial=" + this.getTelefoneResidencial() + ", telefoneComercial=" + this.getTelefoneComercial() + ", telefoneFax=" + this.getTelefoneFax() + ", telefoneCelular=" + this.getTelefoneCelular() + ", email=" + this.getEmail() + ", homePage=" + this.getHomePage() + ", cpf=" + this.getCpf() + ", representanteLegal=" + this.getRepresentanteLegal() + ", representante=" + this.getRepresentante() + ", rg=" + this.getRg() + ", orgaoEmissor=" + this.getOrgaoEmissor() + ", dataJuntaComercial=" + String.valueOf(this.getDataJuntaComercial()) + ", brasileiro=" + this.getBrasileiro() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Contato)) {
            return false;
        }
        Contato other = (Contato)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$representanteLegal = this.getRepresentanteLegal();
        Boolean other$representanteLegal = other.getRepresentanteLegal();
        if (this$representanteLegal == null ? other$representanteLegal != null : !((Object)this$representanteLegal).equals(other$representanteLegal)) {
            return false;
        }
        Long this$representante = this.getRepresentante();
        Long other$representante = other.getRepresentante();
        if (this$representante == null ? other$representante != null : !((Object)this$representante).equals(other$representante)) {
            return false;
        }
        Boolean this$brasileiro = this.getBrasileiro();
        Boolean other$brasileiro = other.getBrasileiro();
        if (this$brasileiro == null ? other$brasileiro != null : !((Object)this$brasileiro).equals(other$brasileiro)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$telefoneResidencial = this.getTelefoneResidencial();
        String other$telefoneResidencial = other.getTelefoneResidencial();
        if (this$telefoneResidencial == null ? other$telefoneResidencial != null : !this$telefoneResidencial.equals(other$telefoneResidencial)) {
            return false;
        }
        String this$telefoneComercial = this.getTelefoneComercial();
        String other$telefoneComercial = other.getTelefoneComercial();
        if (this$telefoneComercial == null ? other$telefoneComercial != null : !this$telefoneComercial.equals(other$telefoneComercial)) {
            return false;
        }
        String this$telefoneFax = this.getTelefoneFax();
        String other$telefoneFax = other.getTelefoneFax();
        if (this$telefoneFax == null ? other$telefoneFax != null : !this$telefoneFax.equals(other$telefoneFax)) {
            return false;
        }
        String this$telefoneCelular = this.getTelefoneCelular();
        String other$telefoneCelular = other.getTelefoneCelular();
        if (this$telefoneCelular == null ? other$telefoneCelular != null : !this$telefoneCelular.equals(other$telefoneCelular)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$homePage = this.getHomePage();
        String other$homePage = other.getHomePage();
        if (this$homePage == null ? other$homePage != null : !this$homePage.equals(other$homePage)) {
            return false;
        }
        String this$cpf = this.getCpf();
        String other$cpf = other.getCpf();
        if (this$cpf == null ? other$cpf != null : !this$cpf.equals(other$cpf)) {
            return false;
        }
        String this$rg = this.getRg();
        String other$rg = other.getRg();
        if (this$rg == null ? other$rg != null : !this$rg.equals(other$rg)) {
            return false;
        }
        String this$orgaoEmissor = this.getOrgaoEmissor();
        String other$orgaoEmissor = other.getOrgaoEmissor();
        if (this$orgaoEmissor == null ? other$orgaoEmissor != null : !this$orgaoEmissor.equals(other$orgaoEmissor)) {
            return false;
        }
        LocalDate this$dataJuntaComercial = this.getDataJuntaComercial();
        LocalDate other$dataJuntaComercial = other.getDataJuntaComercial();
        return !(this$dataJuntaComercial == null ? other$dataJuntaComercial != null : !((Object)this$dataJuntaComercial).equals(other$dataJuntaComercial));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Contato;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $representanteLegal = this.getRepresentanteLegal();
        result = result * 59 + ($representanteLegal == null ? 43 : ((Object)$representanteLegal).hashCode());
        Long $representante = this.getRepresentante();
        result = result * 59 + ($representante == null ? 43 : ((Object)$representante).hashCode());
        Boolean $brasileiro = this.getBrasileiro();
        result = result * 59 + ($brasileiro == null ? 43 : ((Object)$brasileiro).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $telefoneResidencial = this.getTelefoneResidencial();
        result = result * 59 + ($telefoneResidencial == null ? 43 : $telefoneResidencial.hashCode());
        String $telefoneComercial = this.getTelefoneComercial();
        result = result * 59 + ($telefoneComercial == null ? 43 : $telefoneComercial.hashCode());
        String $telefoneFax = this.getTelefoneFax();
        result = result * 59 + ($telefoneFax == null ? 43 : $telefoneFax.hashCode());
        String $telefoneCelular = this.getTelefoneCelular();
        result = result * 59 + ($telefoneCelular == null ? 43 : $telefoneCelular.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $homePage = this.getHomePage();
        result = result * 59 + ($homePage == null ? 43 : $homePage.hashCode());
        String $cpf = this.getCpf();
        result = result * 59 + ($cpf == null ? 43 : $cpf.hashCode());
        String $rg = this.getRg();
        result = result * 59 + ($rg == null ? 43 : $rg.hashCode());
        String $orgaoEmissor = this.getOrgaoEmissor();
        result = result * 59 + ($orgaoEmissor == null ? 43 : $orgaoEmissor.hashCode());
        LocalDate $dataJuntaComercial = this.getDataJuntaComercial();
        result = result * 59 + ($dataJuntaComercial == null ? 43 : ((Object)$dataJuntaComercial).hashCode());
        return result;
    }
}

