/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.Cep;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.EntityPublisher;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.unico.client.dto.CidadeDTO;
import br.com.elotech.unico.client.dto.UfDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.cidade")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
public class Cidade
extends EloDomain<Long>
implements EntityPublisher<CidadeDTO, Long> {
    public static final Cidade CIDADE_INVALIDA = new Cidade().withId(Long.valueOf(0L)).withDescricao("INVALIDA").withUf(UF.UF_INVALIDA).withInativo(Boolean.TRUE);
    @Id
    @EloSequence
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotEmpty
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o")
    private @NotEmpty @Length(max=100) String descricao;
    @Length(max=20)
    @Caption(value="C\u00f3digo Nacional")
    private @Length(max=20) String codigoNacional;
    @Caption(value="C\u00f3digo IBGE")
    private Long codigoIbge;
    @Caption(value="C\u00f3digo APLIC")
    private Long codigoAplic;
    @NotNull
    @ManyToOne
    @JoinColumn(name="unidadefederacao")
    @Caption(value="UF")
    private UF uf;
    @Caption(value="Inativo")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean inativo = Boolean.FALSE;
    @OneToMany(cascade={CascadeType.REFRESH})
    @JoinColumn(name="cidade", updatable=false, nullable=false, insertable=false)
    @Caption(value="Ceps")
    @JsonIgnore
    @AuditJoinTable(name="unico.cidade_cep_aud")
    private Set<Cep> ceps;
    @Caption(value="C\u00f3digo DNE")
    private Long codigoDne;

    public Cidade withInativo(Boolean inativo) {
        this.inativo = inativo;
        return this;
    }

    public Cidade withUf(UF ufInvalida) {
        this.uf = ufInvalida;
        return this;
    }

    public Cidade withId(Long id) {
        this.id = id;
        return this;
    }

    public Cidade withDescricao(String descricao) {
        this.descricao = descricao;
        return this;
    }

    public String hashString() {
        return ReplicatorFacade.hashCodeEloEntity((EloEntity)this.getUf()) + ReplicatorFacade.hashCodeString((String)this.getDescricao());
    }

    public CidadeDTO convertToEvent() {
        CidadeDTO cidadeDTO = new CidadeDTO();
        cidadeDTO.setId(this.id);
        cidadeDTO.setDescricao(this.descricao);
        cidadeDTO.setUf((UfDTO)Optional.ofNullable(this.uf).map(UF::convertToEvent).orElse(null));
        cidadeDTO.setCodigoIbge((Long)Optional.ofNullable(this.codigoIbge).orElse(null));
        cidadeDTO.setInativo(this.inativo);
        return cidadeDTO;
    }

    @Generated
    public String toString() {
        return "Cidade(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", codigoNacional=" + this.getCodigoNacional() + ", codigoIbge=" + this.getCodigoIbge() + ", codigoAplic=" + this.getCodigoAplic() + ", uf=" + String.valueOf(this.getUf()) + ", inativo=" + this.getInativo() + ", ceps=" + String.valueOf(this.getCeps()) + ", codigoDne=" + this.getCodigoDne() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cidade)) {
            return false;
        }
        Cidade other = (Cidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Cidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setCodigoNacional(String codigoNacional) {
        this.codigoNacional = codigoNacional;
    }

    @Generated
    public void setCodigoIbge(Long codigoIbge) {
        this.codigoIbge = codigoIbge;
    }

    @Generated
    public void setCodigoAplic(Long codigoAplic) {
        this.codigoAplic = codigoAplic;
    }

    @Generated
    public void setUf(UF uf) {
        this.uf = uf;
    }

    @Generated
    public void setInativo(Boolean inativo) {
        this.inativo = inativo;
    }

    @JsonIgnore
    @Generated
    public void setCeps(Set<Cep> ceps) {
        this.ceps = ceps;
    }

    @Generated
    public void setCodigoDne(Long codigoDne) {
        this.codigoDne = codigoDne;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getCodigoNacional() {
        return this.codigoNacional;
    }

    @Generated
    public Long getCodigoIbge() {
        return this.codigoIbge;
    }

    @Generated
    public Long getCodigoAplic() {
        return this.codigoAplic;
    }

    @Generated
    public UF getUf() {
        return this.uf;
    }

    @Generated
    public Boolean getInativo() {
        return this.inativo;
    }

    @Generated
    public Set<Cep> getCeps() {
        return this.ceps;
    }

    @Generated
    public Long getCodigoDne() {
        return this.codigoDne;
    }
}

