/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.di.converter.TipoCampoConverter;
import br.com.elotech.di.domain.Alternativa;
import br.com.elotech.di.domain.GrupoCampo;
import br.com.elotech.di.domain.Validacao;
import br.com.elotech.unico.client.domain.TipoCampo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="campo", schema="unico")
@DynamicUpdate
@Audited
public class Campo
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true)
    private Long id;
    @NotNull
    private Long ordem;
    @NotBlank
    @Length(max=100)
    private @NotBlank @Length(max=100) String identificador;
    @NotBlank
    @Length(max=250)
    private @NotBlank @Length(max=250) String descricao;
    @NotNull
    private Long codigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="grupocampo_id", updatable=false)
    @JsonIgnore
    private GrupoCampo grupoCampo;
    @NotNull
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean obrigatorio = Boolean.FALSE;
    @NotNull
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo = Boolean.TRUE;
    @NotNull
    @Convert(converter=TipoCampoConverter.class)
    @Enumerated(value=EnumType.STRING)
    private TipoCampo tipo;
    @JoinColumn(name="campo_id", updatable=false, nullable=false)
    @AuditJoinTable(name="campo_validacao_aud", schema="unico")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<Validacao> validacoes = new ArrayList();
    @JoinColumn(name="campo_id", updatable=false, nullable=false)
    @AuditJoinTable(name="campo_alternativa_aud", schema="unico")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<Alternativa> alternativas = new ArrayList();
    @Length(max=4000)
    private @Length(max=4000) String respostaEsperada;
    @Length(max=4000)
    private @Length(max=4000) String api;
    @Length(max=4000)
    private @Length(max=4000) String parecerPadrao;

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getOrdem() {
        return this.ordem;
    }

    @Generated
    public String getIdentificador() {
        return this.identificador;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getCodigo() {
        return this.codigo;
    }

    @Generated
    public GrupoCampo getGrupoCampo() {
        return this.grupoCampo;
    }

    @Generated
    public Boolean getObrigatorio() {
        return this.obrigatorio;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public TipoCampo getTipo() {
        return this.tipo;
    }

    @Generated
    public List<Validacao> getValidacoes() {
        return this.validacoes;
    }

    @Generated
    public List<Alternativa> getAlternativas() {
        return this.alternativas;
    }

    @Generated
    public String getRespostaEsperada() {
        return this.respostaEsperada;
    }

    @Generated
    public String getApi() {
        return this.api;
    }

    @Generated
    public String getParecerPadrao() {
        return this.parecerPadrao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setOrdem(Long ordem) {
        this.ordem = ordem;
    }

    @Generated
    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @JsonIgnore
    @Generated
    public void setGrupoCampo(GrupoCampo grupoCampo) {
        this.grupoCampo = grupoCampo;
    }

    @Generated
    public void setObrigatorio(Boolean obrigatorio) {
        this.obrigatorio = obrigatorio;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setTipo(TipoCampo tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setValidacoes(List<Validacao> validacoes) {
        this.validacoes = validacoes;
    }

    @Generated
    public void setAlternativas(List<Alternativa> alternativas) {
        this.alternativas = alternativas;
    }

    @Generated
    public void setRespostaEsperada(String respostaEsperada) {
        this.respostaEsperada = respostaEsperada;
    }

    @Generated
    public void setApi(String api) {
        this.api = api;
    }

    @Generated
    public void setParecerPadrao(String parecerPadrao) {
        this.parecerPadrao = parecerPadrao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Campo)) {
            return false;
        }
        Campo other = (Campo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Campo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

