/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.EntityPublisher;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.unico.client.dto.BancoDTO;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.banco")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
public class Banco
extends EloDomain<Long>
implements EntityPublisher<BancoDTO, Long> {
    @Id
    @EloSequence
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotNull
    @Caption(value="C\u00f3digo Banco")
    private Long codigo;
    @NotEmpty
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o")
    private @NotEmpty @Length(max=100) String descricao;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Banco withId(Long id) {
        this.id = id;
        return this;
    }

    public String hashString() {
        return ReplicatorFacade.hashCodeLong((Long)this.codigo);
    }

    public BancoDTO convertToEvent() {
        BancoDTO bancoDTO = new BancoDTO();
        bancoDTO.setId(this.id);
        bancoDTO.setDescricao(this.descricao);
        bancoDTO.setCodigo(this.codigo);
        return bancoDTO;
    }

    @Generated
    public String toString() {
        return "Banco(id=" + this.getId() + ", codigo=" + this.getCodigo() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Banco)) {
            return false;
        }
        Banco other = (Banco)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Banco;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

