/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.LocalidadeAtivo;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.EntityPublisher;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.unico.client.dto.BairroDTO;
import br.com.elotech.unico.client.dto.CidadeDTO;
import br.com.elotech.unico.client.dto.UfDTO;
import java.util.Objects;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.bairro")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
public class Bairro
extends EloDomain<Long>
implements EntityPublisher<BairroDTO, Long>,
LocalidadeAtivo {
    public static final Bairro BAIRRO_INVALIDO = new Bairro().withId(Long.valueOf(0L)).withDescricao("INVALIDO").withInativo(Boolean.TRUE).withCidade(Cidade.CIDADE_INVALIDA);
    @Id
    @EloSequence(sequenceName="S_BAIRRO_ID")
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotEmpty
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o")
    private @NotEmpty @Length(max=100) String descricao;
    @ManyToOne
    @Caption(value="Cidade")
    @NotNull
    private Cidade cidade;
    @Caption(value="Inativo")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean inativo = Boolean.FALSE;

    public Long getId() {
        return this.id;
    }

    public Bairro withInativo(Boolean inativo) {
        this.inativo = inativo;
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Cidade getCidade() {
        return this.cidade;
    }

    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    public Boolean getInativo() {
        return this.inativo;
    }

    public void setInativo(Boolean inativo) {
        this.inativo = inativo;
    }

    public Bairro withId(Long id) {
        this.id = id;
        return this;
    }

    public Bairro withDescricao(String descricao) {
        this.descricao = descricao;
        return this;
    }

    public Bairro withCidade(Cidade cidade) {
        this.cidade = cidade;
        return this;
    }

    public String hashString() {
        return ReplicatorFacade.hashCodeEloEntity((EloEntity)this.getCidade()) + ReplicatorFacade.hashCodeString((String)this.descricao);
    }

    public BairroDTO convertToEvent() {
        UfDTO ufDTO = new UfDTO();
        if (Objects.nonNull(this.cidade) && Objects.nonNull(this.cidade.getUf())) {
            ufDTO.setId(this.cidade.getUf().getId());
            ufDTO.setSigla(this.cidade.getUf().getSigla());
        }
        CidadeDTO cidadeDTO = new CidadeDTO();
        if (Objects.nonNull(this.cidade)) {
            cidadeDTO = this.cidade.convertToEvent();
        }
        BairroDTO bairroDTO = new BairroDTO();
        bairroDTO.setId(this.id);
        bairroDTO.setDescricao(this.descricao);
        bairroDTO.setCidade(cidadeDTO);
        bairroDTO.setInativo(this.inativo);
        return bairroDTO;
    }

    @Generated
    public String toString() {
        return "Bairro(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", cidade=" + String.valueOf(this.getCidade()) + ", inativo=" + this.getInativo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bairro)) {
            return false;
        }
        Bairro other = (Bairro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Bairro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

