/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.unico.client.domain.enums.TipoPeriodicidade;
import br.com.elotech.unico.client.dto.AgendadorArquivoDTO;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.envers.Audited;

@Entity
@Table(name="AGENDADORARQUIVO", schema="unico")
@Audited
public class AgendadorArquivo
implements EloEntity<UUID> {
    @Id
    @GeneratedValue(generator="UUID")
    @GenericGenerator(name="UUID", strategy="org.hibernate.id.UUIDGenerator")
    @Column(name="id", updatable=false, nullable=false)
    private UUID id;
    private Long codModeloArquivo;
    private String nomeModeloArquivo;
    private String horario;
    @Enumerated(value=EnumType.STRING)
    private TipoPeriodicidade periodicidade;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean notificacoes;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo;
    private String email;

    public AgendadorArquivoDTO toDTO() {
        return AgendadorArquivoDTO.builder().id(this.getId()).codModeloArquivo(this.getCodModeloArquivo()).nomeModeloArquivo(this.getNomeModeloArquivo()).horario(this.getHorario()).periodicidade(this.getPeriodicidade()).notificacoes(this.getNotificacoes()).ativo(this.getAtivo()).email(this.getEmail()).build();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public Long getCodModeloArquivo() {
        return this.codModeloArquivo;
    }

    @Generated
    public String getNomeModeloArquivo() {
        return this.nomeModeloArquivo;
    }

    @Generated
    public String getHorario() {
        return this.horario;
    }

    @Generated
    public TipoPeriodicidade getPeriodicidade() {
        return this.periodicidade;
    }

    @Generated
    public Boolean getNotificacoes() {
        return this.notificacoes;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setCodModeloArquivo(Long codModeloArquivo) {
        this.codModeloArquivo = codModeloArquivo;
    }

    @Generated
    public void setNomeModeloArquivo(String nomeModeloArquivo) {
        this.nomeModeloArquivo = nomeModeloArquivo;
    }

    @Generated
    public void setHorario(String horario) {
        this.horario = horario;
    }

    @Generated
    public void setPeriodicidade(TipoPeriodicidade periodicidade) {
        this.periodicidade = periodicidade;
    }

    @Generated
    public void setNotificacoes(Boolean notificacoes) {
        this.notificacoes = notificacoes;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public AgendadorArquivo() {
    }

    @Generated
    public AgendadorArquivo(UUID id, Long codModeloArquivo, String nomeModeloArquivo, String horario, TipoPeriodicidade periodicidade, Boolean notificacoes, Boolean ativo, String email) {
        this.id = id;
        this.codModeloArquivo = codModeloArquivo;
        this.nomeModeloArquivo = nomeModeloArquivo;
        this.horario = horario;
        this.periodicidade = periodicidade;
        this.notificacoes = notificacoes;
        this.ativo = ativo;
        this.email = email;
    }

    @Generated
    public String toString() {
        return "AgendadorArquivo(id=" + String.valueOf(this.getId()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgendadorArquivo)) {
            return false;
        }
        AgendadorArquivo other = (AgendadorArquivo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AgendadorArquivo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

