/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.di.domain.Banco;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.EntityPublisher;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.di.validation.SkipBatch;
import br.com.elotech.unico.client.dto.AgenciaDTO;
import br.com.elotech.unico.client.dto.BancoDTO;
import br.com.elotech.unico.client.dto.CidadeDTO;
import java.util.Optional;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="unico.agencia")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
@Audited
public class Agencia
extends EloDomain<Long>
implements EntityPublisher<AgenciaDTO, Long> {
    public static final int TAMANHO_AGENCIA = 10;
    @Id
    @EloSequence
    @Caption(value="C\u00f3digo")
    private Long id;
    @NotEmpty
    @Length(max=10)
    @Caption(value="Ag\u00eancia")
    private @NotEmpty @Length(max=10) String codigo;
    @ManyToOne
    @Caption(value="Banco")
    @NotNull
    private Banco banco;
    @ManyToOne
    @Caption(value="Cidade")
    private Cidade cidade;
    @NotEmpty(groups={SkipBatch.class})
    @Length(max=50)
    @Caption(value="Descri\u00e7\u00e3o")
    private @NotEmpty(groups={SkipBatch.class}) @Length(max=50) String descricao;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Banco getBanco() {
        return this.banco;
    }

    public void setBanco(Banco banco) {
        this.banco = banco;
    }

    public Cidade getCidade() {
        return this.cidade;
    }

    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    public Agencia withId(Long id) {
        this.id = id;
        return this;
    }

    public Agencia withCodigoDescricaoBanco(String codigo, String descricao, Banco banco) {
        this.codigo = codigo;
        this.banco = banco;
        this.descricao = descricao;
        return this;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String hashString() {
        return ReplicatorFacade.hashCodeEloEntity((EloEntity)this.getBanco()) + ReplicatorFacade.hashCodeString((String)this.getCodigo());
    }

    public Agencia withCidade(Cidade cidade) {
        this.cidade = cidade;
        return this;
    }

    public AgenciaDTO convertToEvent() {
        AgenciaDTO agenciaDTO = new AgenciaDTO();
        agenciaDTO.setId(this.id);
        agenciaDTO.setDescricao(this.descricao);
        agenciaDTO.setBanco((BancoDTO)Optional.ofNullable(this.banco).map(Banco::convertToEvent).orElse(null));
        agenciaDTO.setCodigo(this.codigo);
        agenciaDTO.setCidade((CidadeDTO)Optional.ofNullable(this.cidade).map(Cidade::convertToEvent).orElse(null));
        return agenciaDTO;
    }

    @Generated
    public String toString() {
        return "Agencia(id=" + this.getId() + ", codigo=" + this.getCodigo() + ", banco=" + String.valueOf(this.getBanco()) + ", cidade=" + String.valueOf(this.getCidade()) + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Agencia)) {
            return false;
        }
        Agencia other = (Agencia)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Agencia;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

