/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.converter;

import br.com.elotech.di.domain.Report;
import br.com.elotech.di.domain.ReportJoinField;
import br.com.elotech.di.domain.datasource.QueryExecutorFactory;
import br.com.elotech.di.domain.enums.QueryOperator;
import br.com.elotech.di.domain.query.QueryField;
import br.com.elotech.di.domain.query.QueryResult;
import br.com.elotech.di.domain.query.param.JDBCQueryFilter;
import br.com.elotech.di.dto.ReportExecutionRequest;
import br.com.elotech.di.exception.QueryExecutionException;
import br.com.elotech.di.exception.ReportException;
import br.com.elotech.di.exception.RuntimeQueryExecutionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ReportToMap {
    private final QueryExecutorFactory executorFactory;

    private List<Map<String, Object>> toMap(ReportExecutionRequest request, Report report, Pageable pageable) {
        return this.toMap(new ReportExecutionRequest(report, request.getParams()), pageable);
    }

    private List<Map<String, Object>> toMap(ReportExecutionRequest request, Pageable pageable) {
        Page lists = this.innerExecute(request, pageable);
        return lists.stream().map(l -> {
            Map map = this.createMapRecord(l);
            this.preencherMap(request, map);
            return map;
        }).collect(Collectors.toList());
    }

    private void preencherMap(ReportExecutionRequest request, Map<String, Object> map) {
        Set entries = this.createSubRel(map, request).entrySet();
        for (Map.Entry entry : entries) {
            if (map.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("A key ja foi informada");
            }
            map.put((String)entry.getKey(), entry.getValue());
        }
    }

    private Map<String, Object> createSubRel(Map<String, Object> map, ReportExecutionRequest request) {
        return request.getReport().getSubReport().stream().collect(Collectors.toMap(Report::getName, rep -> {
            this.verificaSeExistemCamposDoJoinSemValor(map, rep);
            return this.consultarDadosDoSubRelatorio(map, request, rep);
        }));
    }

    private List<Map<String, Object>> consultarDadosDoSubRelatorio(Map<String, Object> map, ReportExecutionRequest request, Report rep) {
        List filters = rep.getJoinFields().stream().map(joinField -> this.criarFiltro(map, joinField)).collect(Collectors.toList());
        rep.getQuery().getFilters().addAll(filters);
        List maps = this.toMap(request, rep, Pageable.unpaged());
        rep.getQuery().getFilters().removeAll(filters);
        return maps;
    }

    private JDBCQueryFilter criarFiltro(Map<String, Object> map, ReportJoinField joinField) {
        Object parentValue = map.get(joinField.getParentField().getMapProperty());
        JDBCQueryFilter jdbcQueryParam = new JDBCQueryFilter();
        jdbcQueryParam.setId(Long.valueOf(-1L));
        jdbcQueryParam.setField(joinField.getReportField());
        jdbcQueryParam.setOperator(QueryOperator.EQUAL);
        jdbcQueryParam.setValue(parentValue.toString());
        jdbcQueryParam.setName(joinField.getReportField().getName());
        jdbcQueryParam.setSelected(true);
        return jdbcQueryParam;
    }

    private void verificaSeExistemCamposDoJoinSemValor(Map<String, Object> map, Report rep) {
        List camposSemValor = rep.getJoinFields().stream().filter(joinField -> {
            Object parentValue = map.get(joinField.getParentField().getMapProperty());
            return Objects.isNull(parentValue);
        }).collect(Collectors.toList());
        if (!camposSemValor.isEmpty()) {
            String names = camposSemValor.stream().map(ReportJoinField::getParentField).map(QueryField::getName).collect(Collectors.joining(", "));
            throw new ReportException(String.format("N\u00e3o foi encontrado valor para os atributos (%s)", names));
        }
    }

    private Map<String, Object> createMapRecord(List<QueryResult> record) {
        ArrayList temp = new ArrayList();
        record.forEach(r -> {
            if (temp.contains(r.getMapProperty())) {
                throw new IllegalArgumentException(String.format("A key ja foi informada Key(%s)", r.getMapProperty()));
            }
            temp.add(r.getMapProperty());
        });
        return record.stream().collect(Collectors.toMap(QueryField::getMapProperty, QueryResult::getValue));
    }

    private Page<List<QueryResult>> innerExecute(ReportExecutionRequest request, Pageable pageable) {
        try {
            return this.executorFactory.execute(request.getReport().getQuery(), pageable);
        }
        catch (QueryExecutionException e) {
            throw new RuntimeQueryExecutionException((Throwable)e);
        }
    }

    public List<Map<String, Object>> apply(ReportExecutionRequest request, Pageable pageable) {
        return this.toMap(request, pageable);
    }

    @Generated
    public ReportToMap(QueryExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }
}

