/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.converter;

import br.com.elotech.di.converter.MapToByte;
import br.com.elotech.di.domain.CabecalhoReport;
import br.com.elotech.di.domain.CustomReportDatasource;
import br.com.elotech.di.domain.CustomReportDatasourceBuilder;
import br.com.elotech.di.domain.EntidadeDTO;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public class MapToByte<N, M>
implements Function<List<Map<N, M>>, byte[]> {
    private final EntidadeDTO entidade;
    private final EloReportBuilder report;

    private byte[] generate(List<Map<N, M>> dados) {
        List records = dados.stream().map(QueryResultRecord::new).collect(Collectors.toList());
        DatasetLoader mainDatasetLoader = DatasetLoaders.fromRecords(records, QueryResultRecord.class);
        CustomReportDatasourceBuilder builder = new CustomReportDatasourceBuilder().add("main", (ReportDataLoader)mainDatasetLoader);
        if (Objects.nonNull(this.entidade)) {
            builder = builder.params((ParamLoader)new CabecalhoReport(this.entidade));
        }
        CustomReportDatasource datasource = builder.build();
        return this.report.setReportDatasource((ReportDatasource)datasource).build().exportToPdf();
    }

    @Override
    public byte[] apply(List<Map<N, M>> list) {
        return this.generate(list);
    }

    @Generated
    public MapToByte(EntidadeDTO entidade, EloReportBuilder report) {
        this.entidade = entidade;
        this.report = report;
    }
}

