/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.config;

import br.com.elotech.di.config.UnicoRequestProperties;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="elotech.unico", ignoreUnknownFields=false)
public class UnicoProperties {
    private static final Long FAILED_LOGIN_ATTEMPTS = 3L;
    private Long failedLoginAttempts = FAILED_LOGIN_ATTEMPTS;
    private Boolean idunico = false;
    private Boolean cloud = false;
    private Boolean validateModulos = true;
    private Boolean validateStart = true;
    private UnicoRequestProperties requestLoggingProperties;
    private List<String> idunicoTenants = Collections.emptyList();

    public Boolean getIdunico() {
        if (!this.idunicoTenants.isEmpty() && TenantContextHolder.hasTenant()) {
            return this.idunicoTenants.contains(TenantContextHolder.getTenantId().orElse(""));
        }
        return this.idunico;
    }

    @Generated
    public String toString() {
        return "UnicoProperties(failedLoginAttempts=" + this.getFailedLoginAttempts() + ", idunico=" + this.getIdunico() + ", cloud=" + this.getCloud() + ", validateModulos=" + this.getValidateModulos() + ", validateStart=" + this.getValidateStart() + ", requestLoggingProperties=" + String.valueOf(this.getRequestLoggingProperties()) + ", idunicoTenants=" + String.valueOf(this.getIdunicoTenants()) + ")";
    }

    @Generated
    public void setFailedLoginAttempts(Long failedLoginAttempts) {
        this.failedLoginAttempts = failedLoginAttempts;
    }

    @Generated
    public void setIdunico(Boolean idunico) {
        this.idunico = idunico;
    }

    @Generated
    public void setCloud(Boolean cloud) {
        this.cloud = cloud;
    }

    @Generated
    public void setValidateModulos(Boolean validateModulos) {
        this.validateModulos = validateModulos;
    }

    @Generated
    public void setValidateStart(Boolean validateStart) {
        this.validateStart = validateStart;
    }

    @Generated
    public void setRequestLoggingProperties(UnicoRequestProperties requestLoggingProperties) {
        this.requestLoggingProperties = requestLoggingProperties;
    }

    @Generated
    public void setIdunicoTenants(List<String> idunicoTenants) {
        this.idunicoTenants = idunicoTenants;
    }

    @Generated
    public Long getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    @Generated
    public Boolean getCloud() {
        return this.cloud;
    }

    @Generated
    public Boolean getValidateModulos() {
        return this.validateModulos;
    }

    @Generated
    public Boolean getValidateStart() {
        return this.validateStart;
    }

    @Generated
    public UnicoRequestProperties getRequestLoggingProperties() {
        return this.requestLoggingProperties;
    }

    @Generated
    public List<String> getIdunicoTenants() {
        return this.idunicoTenants;
    }
}

