/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.config;

import br.com.elotech.di.config.OutBoxRegisterScheduleTentant;
import br.com.elotech.di.domain.outbox.OutboxEntity;
import br.com.elotech.di.repository.OutboxRepository;
import br.com.elotech.multitenant.config.MultiTenantClientConfiguration;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.outbox.EnableOutboxConsumerDataIntegration;
import br.com.elotech.outbox.EnableOutboxProducerDataIntegration;
import br.com.elotech.outbox.publisher.PublishKey;
import br.com.elotech.outbox.publisher.RecordEntityClass;
import br.com.elotech.outbox.publisher.RecordSaver;
import br.com.elotech.outbox.publisher.SchedulerPublisher;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Profile;

@Configuration
@EnableOutboxProducerDataIntegration
@EnableOutboxConsumerDataIntegration
@AutoConfigureAfter(value={MultiTenantClientConfiguration.class})
@Profile(value={"cloud"})
public class UnicoOutboxConfiguration {
    @Bean
    public RecordSaver recordSaver(OutboxRepository outboxRepository) {
        return outboxRecord -> outboxRepository.save((Object)((OutboxEntity)outboxRecord));
    }

    @Bean
    public RecordEntityClass recordEntityClass() {
        return OutboxEntity::new;
    }

    @Bean
    public PublishKey publishKey() {
        return () -> TenantContextHolder.getTenantId().orElse("DEFAULT_TENANT");
    }

    @Bean
    @ConditionalOnProperty(name={"elotech.outbox-data-integraton.producer.polling.enabled", "elotech.outbox-data-integration.producer.enabled"}, havingValue="true")
    public OutBoxRegisterScheduleTentant outBoxRegisterScheduleTentant(@Lazy SchedulerPublisher schedulerPublisher) {
        return new OutBoxRegisterScheduleTentant(schedulerPublisher);
    }
}

