/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.config;

import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.unico.client.dto.ArquivoResponseDTO;
import br.com.elotech.unico.client.dto.ErrorResponse;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springdoc.core.GroupedOpenApi;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SwaggerConfiguration {
    @Generated
    private static final Logger log = LogManager.getLogger(SwaggerConfiguration.class);
    private static final String SECURITY_SCHEME_NAME = "Bearer_Authentication";

    @Bean
    public OpenAPI customOpenAPI() {
        return new OpenAPI().components(new Components().addSchemas("PessoaDTO", (Schema)new ObjectSchema().type("PessoaDTO").example((Object)new Pessoa())).addSchemas("ErrorResponse", (Schema)new ObjectSchema().type("ErrorResponse").example((Object)new ErrorResponse())).addSchemas("ArquivoResponseDTO", (Schema)new ObjectSchema().type("ArquivoResponseDTO").example((Object)new ArquivoResponseDTO())).addSecuritySchemes(SECURITY_SCHEME_NAME, this.createOAuthScheme())).addSecurityItem(new SecurityRequirement().addList(SECURITY_SCHEME_NAME)).info(new Info().title("Manual de Integra\u00e7\u00e3o REST - Cadastro \u00danico").version("1.0").description("End-points para integra\u00e7\u00e3o dos sistemas Elotech.").license(new License().name("Apache License Version 2.0").url("https://www.apache.org/licenses/LICENSE-2.0")).contact(new Contact().name("Elotech Gest\u00e3o P\u00fablica").url("http://www.elotech.com.br").email("elotech@elotech.com.br")));
    }

    @Bean
    public GroupedOpenApi configurationIntegracoes() {
        return GroupedOpenApi.builder().group("01integracoes").displayName("01 - Integra\u00e7\u00f5es").packagesToScan(new String[]{"br.com.elotech.di.resource", "br.com.elotech.unico.client.dto", "br.com.elotech.di.resource.dto"}).pathsToMatch(new String[]{"/api/integracoes/**"}).build();
    }

    @Bean
    public GroupedOpenApi configurationGeoreferenciamentoArquivos() {
        return GroupedOpenApi.builder().group("02georeferenciamento").displayName("02 - Georeferenciamento Arquivos").packagesToScan(new String[]{"br.com.elotech.di.resource", "br.com.elotech.di.resource.dto"}).pathsToMatch(new String[]{"**", "/rest/geofileslinksdownload/**"}).pathsToExclude(new String[]{"/api/integracoes/**"}).build();
    }

    private SecurityScheme createOAuthScheme() {
        return new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("bearer").bearerFormat("JWT");
    }
}

