/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.config;

import br.com.elotech.di.config.BatchProperties;
import br.com.elotech.di.utils.DatabaseTypeUtils;
import javax.sql.DataSource;
import org.springframework.batch.admin.service.SimpleJobServiceFactoryBean;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.ListableJobLocator;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableConfigurationProperties(value={BatchProperties.class})
public class SpringBatchAdminConfiguration {
    @Autowired
    private DataSource dataSource;
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private JobLauncher jobLauncher;
    @Autowired
    private JobRegistry jobRegistry;
    @Value(value="${spring.jpa.database:}")
    private String database;

    @Bean
    public JobBuilderFactory jobBuilderFactory(JobRepository jobRepository) {
        return new JobBuilderFactory(jobRepository);
    }

    @Bean
    public StepBuilderFactory stepBuilderFactory(JobRepository jobRepository, PlatformTransactionManager transactionManager) {
        return new StepBuilderFactory(jobRepository, transactionManager);
    }

    @Bean
    public SimpleJobServiceFactoryBean simpleJobServiceFactoryBean(ExecutionContextSerializer serializer) {
        SimpleJobServiceFactoryBean bean = new SimpleJobServiceFactoryBean();
        bean.setDataSource(this.dataSource);
        bean.setJobRepository(this.jobRepository);
        bean.setJobLauncher(this.jobLauncher);
        bean.setJobLocator((ListableJobLocator)this.jobRegistry);
        bean.setSerializer(serializer);
        bean.setMaxVarCharLength(4000);
        bean.setDatabaseType(DatabaseTypeUtils.getDatabaseType((String)this.database));
        return bean;
    }
}

