/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.config;

import br.com.elotech.di.config.UnicoProperties;
import br.com.elotech.di.config.UnicoRequestProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.CommonsRequestLoggingFilter;

@ConditionalOnProperty(name={"elotech.unico.requestLoggingProperties.enabledRequestLog"}, havingValue="true")
@Configuration
public class RequestLoggingFilterConfiguration {
    private final UnicoProperties unicoProperties;

    public RequestLoggingFilterConfiguration(UnicoProperties unicoProperties) {
        this.unicoProperties = unicoProperties;
    }

    @Bean
    public CommonsRequestLoggingFilter logFilter() {
        CommonsRequestLoggingFilter filter = new CommonsRequestLoggingFilter();
        UnicoRequestProperties requestProperties = this.unicoProperties.getRequestLoggingProperties();
        filter.setIncludeQueryString(requestProperties.getIncludeQueryString().booleanValue());
        filter.setIncludePayload(requestProperties.getIncludePayLoad().booleanValue());
        filter.setMaxPayloadLength(requestProperties.getMaxPayloadLength());
        filter.setIncludeHeaders(requestProperties.getIncludeHeaders().booleanValue());
        filter.setIncludeClientInfo(requestProperties.getIncludeClientInfo().booleanValue());
        filter.setBeforeMessageSuffix(requestProperties.getMessageSuffix());
        filter.setAfterMessagePrefix(requestProperties.getMessagePrefix());
        return filter;
    }
}

