/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.config;

import br.com.elotech.core.config.MappingConverters;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.redis.cache.BatchStrategies;
import org.springframework.data.redis.cache.BatchStrategy;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@Profile(value={"!test"})
public class RedisConfig {
    public static final long TIMEOUT = 60L;
    private final RedisProperties redisProperties;

    @Bean
    @Profile(value={"cloudlocal"})
    public LettuceConnectionFactory redisConnectionFactory() {
        LettuceClientConfiguration.LettuceClientConfigurationBuilder config = LettuceClientConfiguration.builder().commandTimeout(Optional.ofNullable(this.redisProperties.getTimeout()).orElse(Duration.ofSeconds(60L))).shutdownTimeout(Duration.ZERO);
        return new LettuceConnectionFactory(new RedisStandaloneConfiguration(this.redisProperties.getHost(), this.redisProperties.getPort()), config.build());
    }

    @Bean
    @Profile(value={"!cloudlocal"})
    @ConditionalOnMissingBean(value={LettuceConnectionFactory.class})
    public LettuceConnectionFactory redisClusterConnectionFactory() {
        LettuceClientConfiguration.LettuceSslClientConfigurationBuilder config = LettuceClientConfiguration.builder().commandTimeout(Optional.ofNullable(this.redisProperties.getTimeout()).orElse(Duration.ofSeconds(60L))).shutdownTimeout(Duration.ZERO).useSsl().disablePeerVerification();
        return new LettuceConnectionFactory(new RedisClusterConfiguration(List.of(String.format("%s:%s", this.redisProperties.getHost(), this.redisProperties.getPort()))), config.build());
    }

    @Bean
    public RedisTemplate<?, ?> redisTemplate(RedisConnectionFactory factory) {
        ObjectMapper objectMapper = MappingConverters.configureObjectMapper((ObjectMapper)new ObjectMapper());
        objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(factory);
        template.setEnableDefaultSerializer(true);
        template.setDefaultSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer(objectMapper));
        return template;
    }

    @Bean
    public CacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory) {
        return RedisCacheManager.RedisCacheManagerBuilder.fromCacheWriter((RedisCacheWriter)RedisCacheWriter.lockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory, (BatchStrategy)BatchStrategies.scan((int)1000))).cacheDefaults(RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofMinutes(10L)).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer()))).build();
    }

    @Generated
    public RedisConfig(RedisProperties redisProperties) {
        this.redisProperties = redisProperties;
    }
}

