/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.config;

import br.com.elotech.core.security.Http401UnauthorizedEntryPoint;
import br.com.elotech.core.security.SecurityConfigurationOverride;
import br.com.elotech.di.config.IntegracoesCadastroUnicoSecurityFilter;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.Filter;
import org.keycloak.adapters.springsecurity.KeycloakSecurityComponents;
import org.keycloak.adapters.springsecurity.config.KeycloakWebSecurityConfigurerAdapter;
import org.keycloak.adapters.springsecurity.filter.KeycloakPreAuthActionsFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;

@org.keycloak.adapters.springsecurity.KeycloakConfiguration
@ComponentScan(basePackageClasses={KeycloakSecurityComponents.class})
@Profile(value={"cloud"})
public class KeycloakConfiguration
extends KeycloakWebSecurityConfigurerAdapter
implements SecurityConfigurationOverride {
    public static final int DOIS = 2;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider((AuthenticationProvider)this.keycloakAuthenticationProvider());
    }

    protected SessionAuthenticationStrategy sessionAuthenticationStrategy() {
        return new NullAuthenticatedSessionStrategy();
    }

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/public/**"})).antMatchers(new String[]{"/actuator/**"})).antMatchers(new String[]{"/*/actuator/**"})).antMatchers(new String[]{"/rest/app/params"})).antMatchers(new String[]{"/v3/api-docs**"})).antMatchers(new String[]{"/v3/api-docs/**"})).antMatchers(new String[]{"/swagger-ui/**"})).antMatchers(new String[]{"/swagger-ui.html"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.cors().and()).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).sessionAuthenticationStrategy(this.sessionAuthenticationStrategy()).and()).authorizeRequests().antMatchers(new String[]{"/api/**", "/rest/**"})).authenticated().and()).anonymous().disable()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new Http401UnauthorizedEntryPoint());
    }

    @Bean
    public FilterRegistrationBean<KeycloakPreAuthActionsFilter> keycloakPreAuthActionsFilterRegistrationBean(KeycloakPreAuthActionsFilter filter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setEnabled(false);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<IntegracoesCadastroUnicoSecurityFilter> integracaoGeoArquivoSecurityFilter(ObjectMapper objectMapper) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new IntegracoesCadastroUnicoSecurityFilter(objectMapper));
        registrationBean.setEnabled(true);
        registrationBean.setOrder(SecurityWebFiltersOrder.AUTHORIZATION.getOrder() + 2);
        return registrationBean;
    }
}

