/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.config;

import br.com.elotech.di.utils.SecurityUtils;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.multitenant.utils.ResponseUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;

public class IntegracoesCadastroUnicoSecurityFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracoesCadastroUnicoSecurityFilter.class);
    private static final String URI_AUTHORIZED = "/api/integracoes/";
    private final ObjectMapper objectMapper;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String currentTenantId = TenantContextHolder.getTenantId().orElse("");
        String tokenTenant = SecurityUtils.getTenantIntegracaoRequerimento();
        if (StringUtils.isBlank((CharSequence)tokenTenant)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        boolean sameTenant = currentTenantId.equals(tokenTenant);
        if (!sameTenant) {
            String mensagemFormatada = "Voc\u00ea n\u00e3o tem permiss\u00e3o para acessar os recursos desse cliente.";
            ResponseUtils.sendError((HttpServletResponse)response, (ObjectMapper)this.objectMapper, (HttpStatus)HttpStatus.FORBIDDEN, (String)mensagemFormatada);
            return;
        }
        log.debug("Token identificado como usu\u00e1rio de integra\u00e7\u00e3o no cadastro \u00fanico");
        String urlWithoutContextPath = request.getRequestURI().replace(request.getContextPath(), "");
        if (!urlWithoutContextPath.startsWith(URI_AUTHORIZED)) {
            String mensagemFormatada = "Esse token s\u00f3 tem permiss\u00e3o para acessar os recursos de integra\u00e7\u00f5es. Consulte a documenta\u00e7\u00e3o.";
            ResponseUtils.sendError((HttpServletResponse)response, (ObjectMapper)this.objectMapper, (HttpStatus)HttpStatus.FORBIDDEN, (String)mensagemFormatada);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Generated
    public IntegracoesCadastroUnicoSecurityFilter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

