/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.config;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class EventBusPostProcessor
implements BeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(EventBusPostProcessor.class);
    @Autowired
    private EventBus eventBus;

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Method[] methods;
        for (Method method : methods = bean.getClass().getMethods()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = method.getAnnotations()) {
                if (!annotation.annotationType().equals(Subscribe.class)) continue;
                this.eventBus.register(bean);
                LOG.trace("Bean {} containing method {} was subscribed to {}", new Object[]{beanName, method.getName(), EventBus.class.getCanonicalName()});
                return bean;
            }
        }
        return bean;
    }
}

