/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.writer;

import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.replicate.support.Replicable;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ValidatorWriter {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    @PersistenceContext
    private EntityManager em;

    private <U extends Serializable, S extends EloDomain<U>> void validateClass(Class<S> type, Class<? extends Replicable<S, U>> clazz, boolean throwExceptionOnNotExistsInLegado) {
        TypedQuery query = this.em.createQuery(String.format("select count(a) from  %s a where idunico is null", clazz.getSimpleName()), Long.class);
        long count = (Long)query.getSingleResult();
        if (count > 0L) {
            throw new IllegalStateException(String.format("Exists in class %s %d records with idunicos nulls.", clazz.getSimpleName(), count));
        }
        query = this.em.createQuery(String.format("select count(a) from  %s a where hashstring is null", type.getSimpleName()), Long.class);
        count = (Long)query.getSingleResult();
        if (count > 0L) {
            throw new IllegalStateException(String.format("Exists in class %s %d records with hashstring nulls.", type.getSimpleName(), count));
        }
        List idUnicoDuplicado = this.em.createQuery(String.format("select a.idUnico from  %s a group by a.idUnico having count(a.idUnico) > 1", clazz.getSimpleName()), Long.class).getResultList();
        if (!idUnicoDuplicado.isEmpty()) {
            String idsUnico = idUnicoDuplicado.stream().map(Object::toString).collect(Collectors.joining(","));
            throw new IllegalStateException(String.format("Existe mais de um registro com o mesmo IdUnico para a classe %s. IdsUnicos com duplica\u00e7\u00e3o: %s", clazz.getSimpleName(), idsUnico));
        }
        List idUnicoNaoReplicado = this.em.createQuery(String.format("select a.id from %s a where not exists (from %s b where idunico = a.id)", type.getSimpleName(), clazz.getSimpleName()), Long.class).getResultList();
        if (!idUnicoNaoReplicado.isEmpty()) {
            String idsUnico = idUnicoNaoReplicado.stream().map(Object::toString).collect(Collectors.joining(","));
            String msg = String.format("Existem %d registros da classe %s que n\u00e3o foram encontrados para a classe %s. IdsUnicos n\u00e3o replicados: %s", idUnicoNaoReplicado.size(), type.getSimpleName(), clazz.getSimpleName(), idsUnico);
            if (throwExceptionOnNotExistsInLegado) {
                throw new IllegalStateException(msg);
            }
            this.log.warn(msg);
        }
    }

    public <U extends Serializable, S extends EloDomain<U>> void validate(Class<S> unicoType, Set<Class<? extends Replicable<S, U>>> legadoClasses, boolean throwExceptionOnNotExistsInLegado) {
        if (legadoClasses.isEmpty()) {
            throw new IllegalArgumentException("Set of Legados Class is empty");
        }
        this.log.info(String.format("Validation writer for class %s", unicoType.getSimpleName()));
        for (Class<Replicable<S, U>> clazz : legadoClasses) {
            this.validateClass(unicoType, clazz, throwExceptionOnNotExistsInLegado);
        }
    }
}

