/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.writer;

import br.com.elotech.di.batch.writer.AbstractCompositeItemWriter;
import br.com.elotech.di.batch.writer.TupleLink;
import br.com.elotech.di.domain.Grupo;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.support.UsuarioSupport;
import br.com.elotech.di.replicate.support.Replicable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ItemWriterUsuario
extends AbstractCompositeItemWriter<Usuario, Long> {
    @Autowired
    private UsuarioSupport usuarioSupport;

    protected void beforeFinish() {
        this.usuarioSupport.attrPermissaoAndEntidades("root");
    }

    protected void beforeWrite(List<TupleLink<Usuario, Long>> tuples, List<Usuario> unicos, List<Replicable<Usuario, Long>> legados) {
        super.beforeWrite(tuples, unicos, legados);
        for (Usuario usuario : unicos) {
            usuario.getGrupos().add(Grupo.GRUPO_USUARIO);
        }
        ConcurrentMap<String, List<Usuario>> map = unicos.parallelStream().collect(Collectors.groupingByConcurrent(u -> u.getUsuario()));
        for (Map.Entry group : map.entrySet()) {
            if (!this.isInvalidUser((List)group.getValue())) continue;
            this.markUsersAsInvalid(group);
        }
    }

    private boolean isInvalidUser(List<Usuario> usuarios) {
        if (usuarios.stream().anyMatch(u -> u.isFixedUser())) {
            return false;
        }
        return usuarios.stream().map(u -> u.getHashString()).distinct().count() != 1L;
    }

    private void markUsersAsInvalid(Map.Entry<String, List<Usuario>> group) {
        HashMap<String, ArrayList<Usuario>> prefixes = new HashMap<String, ArrayList<Usuario>>();
        this.getLog().info("M\u00faltiplos usu\u00e1rios encontrados com login \"{}\". Usu\u00e1rios ser\u00e3o definidos como inv\u00e1lido.", (Object)group.getKey());
        for (Usuario usuario : group.getValue()) {
            if (usuario.getInvalido().booleanValue()) continue;
            usuario.setInvalido(Boolean.TRUE);
            String prefix = this.prefixedUserName(usuario);
            if (prefixes.containsKey(prefix)) {
                if (((List)prefixes.get(prefix)).size() == 1) {
                    Usuario user = (Usuario)((List)prefixes.get(prefix)).get(0);
                    user.setUsuario(user.getUsuario().replace(prefix, ""));
                }
                ((List)prefixes.get(prefix)).add(usuario);
                for (int i = 0; i < ((List)prefixes.get(prefix)).size(); ++i) {
                    this.attrUserName(prefix + (i + 1), (Usuario)((List)prefixes.get(prefix)).get(i));
                }
                continue;
            }
            prefixes.put(prefix, new ArrayList<Usuario>(Arrays.asList(usuario)));
            this.attrUserName(prefix, usuario);
        }
    }

    private String prefixedUserName(Usuario usuario) {
        int prefix = usuario.getSourceClass().charAt(0);
        if (usuario.getSourceClass().startsWith("Apice")) {
            prefix = 67;
        }
        return (char)prefix + "_";
    }

    private void attrUserName(String prefix, Usuario usuario) {
        if (!usuario.getUsuario().contains(prefix)) {
            usuario.setUsuario(prefix + usuario.getUsuario());
            if (usuario.getUsuario().length() > 248) {
                usuario.setUsuario(UUID.randomUUID().toString().replace('-', ' ').trim().substring(0, 248));
            }
        }
    }

    protected boolean alwaysCreateNew() {
        return false;
    }
}

