/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.writer;

import br.com.elotech.di.batch.writer.AbstractCompositeItemWriter;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.apice.ApicePessoa;
import br.com.elotech.di.replicate.apice.ReplicatorPessoaApiceAssociations;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.di.repository.Pessoas;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ItemWriterSocioPessoa
extends AbstractCompositeItemWriter<Pessoa, Long>
implements InitializingBean {
    @Autowired
    private ReplicatorFacade replicatorFacade;
    @Autowired
    private Pessoas pessoas;
    private ReplicatorPessoaApiceAssociations replicatorPessoaApiceAssociations;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.replicatorPessoaApiceAssociations = new ReplicatorPessoaApiceAssociations(this.replicatorFacade);
    }

    public void write(List<? extends Replicable<Pessoa, Long>> items) {
        ArrayList<Pessoa> listUnico = new ArrayList<Pessoa>();
        for (Replicable<Pessoa, Long> replicable : items) {
            ApicePessoa apicePessoa = (ApicePessoa)replicable;
            Pessoa pessoa = (Pessoa)this.pessoas.findOne((Object)apicePessoa.getIdUnico());
            listUnico.add(pessoa);
            this.replicatorPessoaApiceAssociations.createSociosUnico(pessoa, apicePessoa);
        }
        this.pessoas.saveAll(listUnico);
        this.pessoas.flush();
    }

    protected boolean throwExceptionOnNotExistsInLegado() {
        return false;
    }
}

