/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.writer;

import br.com.elotech.di.domain.LeiAto;
import br.com.elotech.di.domain.aise.AiseAto;
import br.com.elotech.di.domain.siscop.SiscopLeisAtos;
import br.com.elotech.di.jpa.hibernate.HibernateUtils;
import br.com.elotech.di.replicate.aise.ReplicatorLeiAtoAiseAdditional;
import br.com.elotech.di.replicate.siscop.ReplicatorLeiAtoSiscopAdditional;
import br.com.elotech.di.replicate.support.Replicable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.stereotype.Component;

@Component
public class ItemWriterLeiAtoPublicacao
implements ItemWriter<Replicable<LeiAto, Long>> {
    @Autowired
    private ReplicatorLeiAtoAiseAdditional replicatorLeiAtoAiseAdditional;
    @Autowired
    private ReplicatorLeiAtoSiscopAdditional replicatorLeiAtoSiscopAdditional;
    @Autowired
    private EntityManagerFactory emf;

    public void write(List<? extends Replicable<LeiAto, Long>> items) {
        EntityManager em = EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.emf);
        ArrayList unicos = new ArrayList();
        ArrayList legados = new ArrayList();
        this.replicateUnico(items, em, unicos, legados);
        this.replicateLegado(unicos, legados);
        unicos.stream().forEach(uni -> em.merge(uni));
        legados.stream().forEach(leg -> em.merge(leg));
        em.flush();
    }

    private void replicateLegado(List<LeiAto> unicos, List<Replicable<LeiAto, Long>> legados) {
        for (LeiAto unico : unicos) {
            List legadoListFilter = legados.stream().filter(leg -> ((Long)leg.getIdUnico()).equals(unico.getId())).collect(Collectors.toList());
            for (Replicable legado : legadoListFilter) {
                if (AiseAto.class.isAssignableFrom(legado.getClass())) {
                    this.replicatorLeiAtoAiseAdditional.from(unico, (AiseAto)legado);
                    continue;
                }
                if (!SiscopLeisAtos.class.isAssignableFrom(legado.getClass())) continue;
                this.replicatorLeiAtoSiscopAdditional.from(unico, (SiscopLeisAtos)legado);
            }
        }
    }

    private void replicateUnico(List<? extends Replicable<LeiAto, Long>> items, EntityManager em, List<LeiAto> unicos, List<Replicable<LeiAto, Long>> legados) {
        for (Replicable<LeiAto, Long> replicable : items) {
            Replicable legado = (Replicable)HibernateUtils.reAttachToSession((EntityManagerFactory)this.emf, replicable);
            legados.add((Replicable<LeiAto, Long>)legado);
            LeiAto unico = this.getUnico(em, unicos, legado);
            if (AiseAto.class.isAssignableFrom(legado.getClass())) {
                this.replicatorLeiAtoAiseAdditional.to((AiseAto)legado, unico);
                continue;
            }
            if (!SiscopLeisAtos.class.isAssignableFrom(legado.getClass())) continue;
            this.replicatorLeiAtoSiscopAdditional.to((SiscopLeisAtos)legado, unico);
        }
    }

    private LeiAto getUnico(EntityManager em, List<LeiAto> unicos, Replicable<LeiAto, Long> replicable) {
        LeiAto unico = unicos.stream().filter(uni -> uni.getId().equals(replicable.getIdUnico())).findAny().orElse(null);
        if (unico == null) {
            unico = (LeiAto)em.find(LeiAto.class, (Object)replicable.getIdUnico());
            unicos.add(unico);
            if (unico == null) {
                throw new IllegalStateException(String.format("N\u00e3o encontrada lei ato com id %s", replicable.getIdUnico()));
            }
        }
        return unico;
    }
}

