/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.writer;

import br.com.elotech.di.jpa.support.EloJpaEntityInformation;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.batch.item.database.JpaItemWriter;

public class EloJpaItemWriter<T>
extends JpaItemWriter<T> {
    protected void doWrite(EntityManager entityManager, List<? extends T> items) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Writing to JPA with " + items.size() + " items."));
        }
        if (!items.isEmpty()) {
            long mergeCount = 0L;
            for (int i = 0; i < items.size(); ++i) {
                T item = items.get(i);
                EloJpaEntityInformation jpaEntityInformation = new EloJpaEntityInformation(item.getClass(), entityManager.getMetamodel());
                if (jpaEntityInformation.isNew(item)) {
                    entityManager.persist(item);
                    continue;
                }
                if (entityManager.contains(item)) continue;
                entityManager.merge(item);
                ++mergeCount;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(mergeCount + " entities merged."));
                logger.debug((Object)((long)items.size() - mergeCount + " entities found in persistence context."));
            }
            entityManager.flush();
            logger.debug((Object)"Flushing...");
        }
    }
}

