/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.writer;

import br.com.elotech.di.batch.job.BatchContextHolder;
import br.com.elotech.di.batch.writer.BatchReplicateLegadoSupport;
import br.com.elotech.di.batch.writer.CompositeItemWriter;
import br.com.elotech.di.batch.writer.EloJpaItemWriter;
import br.com.elotech.di.batch.writer.TupleLink;
import br.com.elotech.di.config.BatchProperties;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.event.StepWriteEvent;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.di.replicate.support.Replicator;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchWriterSupport<S extends EloDomain<U>, U extends Serializable> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final CompositeItemWriter<S, U> compositeItemWriter;
    private final EloJpaItemWriter<S> itemWriterUnico;
    private final EloJpaItemWriter<Replicable<S, U>> itemWriterLegado;
    private final BatchProperties batchProperties;

    public BatchWriterSupport(CompositeItemWriter<S, U> compositeItemWriter, EloJpaItemWriter<S> itemWriterUnico, EloJpaItemWriter<Replicable<S, U>> itemWriterLegado, BatchProperties batchProperties) {
        this.compositeItemWriter = compositeItemWriter;
        this.itemWriterUnico = itemWriterUnico;
        this.itemWriterLegado = itemWriterLegado;
        this.batchProperties = batchProperties;
    }

    public void writeAll(List<TupleLink<S, U>> tuples, List<S> unicos, List<Replicable<S, U>> legados) {
        HashMap<CallSite, Replicable> legadosComIdUnico = new HashMap<CallSite, Replicable>();
        for (TupleLink<S, U> entry : tuples) {
            legadosComIdUnico.put((CallSite)((Object)(entry.getReplicable().getClass().getSimpleName() + String.valueOf(entry.getUnico().getId()))), entry.getReplicable());
        }
        BatchReplicateLegadoSupport replicatorLegados = new BatchReplicateLegadoSupport(this.compositeItemWriter);
        Map newLegados = replicatorLegados.replicateLegados(Collections.unmodifiableList(legados), Collections.unmodifiableList(tuples), legadosComIdUnico);
        for (EloDomain unico : this.compositeItemWriter.getUnicosTemporaryId()) {
            unico.setId(null);
        }
        int totalItemCount = unicos.size() + newLegados.size();
        AtomicLong itemCount = new AtomicLong();
        this.compositeItemWriter.getEventBus().post((Object)new StepWriteEvent(BatchContextHolder.getJobNameStarted(), this.compositeItemWriter.getStepName(), itemCount.intValue(), totalItemCount));
        this.saveWithHandleExceptionAndIncrement(this.itemWriterUnico, unicos, itemCount, totalItemCount, false);
        for (TupleLink<S, U> tupleLink : tuples) {
            tupleLink.getReplicable().setIdUnico(tupleLink.getUnico().getId());
        }
        for (Map.Entry entry : newLegados.entrySet()) {
            ((Replicable)entry.getKey()).setIdUnico(((EloDomain)entry.getValue()).getId());
        }
        for (Replicator replicator : this.compositeItemWriter.getReplicators()) {
            List legadosToSave = newLegados.keySet().stream().filter(i -> i.getClass().equals(replicator.getReplicableType())).collect(Collectors.toList());
            this.saveWithHandleExceptionAndIncrement(this.itemWriterLegado, legadosToSave, itemCount, totalItemCount, false);
        }
    }

    public void writeChunked(List<TupleLink<S, U>> tuples, List<S> unicos, List<Replicable<S, U>> legados) {
        this.saveWithHandleExceptionAndIncrement(this.itemWriterUnico, unicos, new AtomicLong(), 0, true);
        HashMap<CallSite, Replicable> legadosComIdUnico = new HashMap<CallSite, Replicable>();
        for (TupleLink<S, U> entry : tuples) {
            entry.getReplicable().setIdUnico(entry.getUnico().getId());
            legadosComIdUnico.put((CallSite)((Object)(entry.getReplicable().getClass().getSimpleName() + String.valueOf(entry.getUnico().getId()))), entry.getReplicable());
        }
        for (TupleLink<S, U> tuple : tuples) {
            this.log.trace("Replicated from [" + String.valueOf(tuple.getReplicable()) + "] to [" + String.valueOf(tuple.getUnico()) + "]");
        }
        this.replicateToLegado(tuples, legados, legadosComIdUnico);
    }

    private void replicateToLegado(List<TupleLink<S, U>> tuples, List<Replicable<S, U>> legados, Map<String, Replicable<S, U>> legadosComIdUnico) {
        BatchReplicateLegadoSupport replicatorLegados = new BatchReplicateLegadoSupport(this.compositeItemWriter);
        Map newLegados = replicatorLegados.replicateLegados(Collections.unmodifiableList(legados), Collections.unmodifiableList(tuples), legadosComIdUnico);
        for (Replicator replicator : this.compositeItemWriter.getReplicators()) {
            List legadosToSave = newLegados.keySet().stream().filter(i -> i.getClass().equals(replicator.getReplicableType())).collect(Collectors.toList());
            this.saveWithHandleExceptionAndIncrement(this.itemWriterLegado, legadosToSave, new AtomicLong(), 0, true);
        }
    }

    private <T> void saveWithHandleExceptionAndIncrement(EloJpaItemWriter<T> itemWriter, List<T> listToSave, AtomicLong itemCount, int totalItemCount, boolean chunked) {
        if (listToSave.isEmpty()) {
            return;
        }
        String typeName = listToSave.get(0).getClass().getSimpleName();
        try {
            List partitions = Lists.partition(listToSave, (int)this.batchProperties.getFlushSize());
            for (List partition : partitions) {
                itemCount.addAndGet(partition.size());
                itemWriter.write(partition);
                if (chunked) continue;
                this.compositeItemWriter.getEventBus().post((Object)new StepWriteEvent(BatchContextHolder.getJobNameStarted(), this.compositeItemWriter.getStepName(), itemCount.intValue(), totalItemCount));
            }
        }
        catch (PersistenceException e) {
            for (T obj : listToSave) {
                this.log.debug(String.format("Error saving type %s:  %s.", typeName, obj));
            }
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            throw new HibernateException(String.format("Erro na replica\u00e7\u00e3o. Classe: %s. Mensagem: %s", typeName, rootCauseMessage), (Throwable)e);
        }
    }
}

