/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.writer;

import br.com.elotech.di.batch.writer.CompositeItemWriter;
import br.com.elotech.di.batch.writer.TupleLink;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.di.replicate.support.Replicator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BatchReplicateLegadoSupport<S extends EloDomain<U>, U extends Serializable> {
    private static final Logger LOG = LoggerFactory.getLogger(BatchReplicateLegadoSupport.class);
    private final CompositeItemWriter<S, U> compositeItemWriter;

    public BatchReplicateLegadoSupport(CompositeItemWriter<S, U> compositeItemWriter) {
        this.compositeItemWriter = compositeItemWriter;
    }

    public Map<Replicable<S, U>, S> replicateLegados(List<Replicable<S, U>> legadosList, List<TupleLink<S, U>> tuples, Map<String, Replicable<S, U>> legadosComIdUnico) {
        IdentityHashMap result = new IdentityHashMap();
        for (Replicator replicator : this.compositeItemWriter.getReplicators()) {
            Class classType = replicator.getReplicableType();
            Replicator replicatorObj = replicator;
            this.execute(classType, replicatorObj, tuples, legadosComIdUnico, result);
        }
        return Collections.unmodifiableMap(result);
    }

    private void execute(Class<? extends Replicable<S, U>> classType, Replicator<S, U, Replicable<S, U>> replicator, List<TupleLink<S, U>> tuples, Map<String, Replicable<S, U>> legadosComIdUnico, Map<Replicable<S, U>, S> result) {
        ArrayList<Replicable> newLegados = new ArrayList<Replicable>();
        for (TupleLink<S, U> tuple : tuples) {
            if (!classType.equals(tuple.getReplicable().getClass()) && !legadosComIdUnico.containsKey(classType.getSimpleName() + String.valueOf(tuple.getUnico().getId())) && replicator.canReplicateFor(tuple.getUnico()) && this.compositeItemWriter.allowReplicateFor(tuple.getReplicable().getClass(), classType)) {
                Replicable newLegado = (Replicable)BeanUtils.instantiateClass(classType);
                try {
                    newLegado = replicator.from(tuple.getUnico(), newLegado);
                    LOG.trace("Replicate from [" + String.valueOf(tuple.getUnico()) + "] to [" + String.valueOf(newLegado) + "]");
                }
                catch (EntityNotFoundException e) {
                    throw new PersistenceException("Erro na replica\u00e7\u00e3o para a classe [" + String.valueOf(classType) + "] do item " + String.valueOf(tuple.getUnico()), (Throwable)e);
                }
                this.compositeItemWriter.onReplicateLegado(tuple.getReplicable(), newLegado);
                legadosComIdUnico.put(newLegado.getClass().getSimpleName() + String.valueOf(tuple.getUnico().getId()), newLegado);
                newLegados.add(newLegado);
                result.put(newLegado, tuple.getUnico());
                continue;
            }
            LOG.trace("Skip replication to " + String.valueOf(classType) + " from unico " + String.valueOf(tuple.getUnico()));
        }
    }
}

