/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.writer;

import br.com.elotech.core.utils.ReflectionUtils;
import br.com.elotech.di.batch.writer.BatchWriterSupport;
import br.com.elotech.di.batch.writer.CompositeItemWriter;
import br.com.elotech.di.batch.writer.EloJpaItemWriter;
import br.com.elotech.di.batch.writer.TupleLink;
import br.com.elotech.di.batch.writer.ValidatorWriter;
import br.com.elotech.di.config.BatchProperties;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.exception.ReplicatorNotFound;
import br.com.elotech.di.jpa.hibernate.HibernateUtils;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.di.replicate.support.Replicator;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCompositeItemWriter<S extends EloDomain<U>, U extends Serializable>
implements ItemWriter<Replicable<S, U>>,
InitializingBean,
CompositeItemWriter<S, U> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    @PersistenceUnit
    private EntityManagerFactory emf;
    @Autowired
    private EntityManager em;
    @Autowired
    private ValidatorWriter validatorWriter;
    @Autowired
    private EventBus eventBus;
    @Autowired
    private List<Replicator<S, U, ? extends Replicable<S, U>>> replicators;
    @Autowired
    private BatchProperties batchProperties;
    private EloJpaItemWriter<S> itemWriterUnico;
    private EloJpaItemWriter<Replicable<S, U>> itemWriterLegado;
    private StepExecution stepExecution;
    private final List<S> unicosTemporaryId = new ArrayList();
    private boolean chunked;

    public List<Replicator<S, U, ? extends Replicable<S, U>>> getReplicators() {
        return this.replicators;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public String getStepName() {
        return this.stepExecution.getStepName();
    }

    public List<S> getUnicosTemporaryId() {
        return this.unicosTemporaryId;
    }

    public void afterPropertiesSet() {
        this.itemWriterUnico = new EloJpaItemWriter();
        this.itemWriterUnico.setEntityManagerFactory(this.emf);
        this.itemWriterLegado = new EloJpaItemWriter();
        this.itemWriterLegado.setEntityManagerFactory(this.emf);
    }

    protected EloJpaItemWriter<S> getItemWriterUnico() {
        return this.itemWriterUnico;
    }

    public void write(List<? extends Replicable<S, U>> items) {
        ArrayList<Replicable<S, U>> legados = new ArrayList<Replicable<S, U>>();
        ArrayList tuples = new ArrayList();
        ArrayList unicos = new ArrayList();
        HashMap mergeTuple = new HashMap();
        Class typeUnico = ReflectionUtils.getClassParameterizedType(this.getClass());
        for (Replicable<S, U> replicable : items) {
            legados.add(replicable);
            Replicable replicable2 = (Replicable)HibernateUtils.reAttachToSession((EntityManagerFactory)this.emf, replicable);
            this.internalReplicateUnico(tuples, unicos, replicable2, typeUnico, mergeTuple);
        }
        this.beforeWrite(tuples, unicos, legados);
        BatchWriterSupport writerSupport = new BatchWriterSupport((CompositeItemWriter)this, this.itemWriterUnico, this.itemWriterLegado, this.batchProperties);
        if (this.chunked) {
            writerSupport.writeChunked(tuples, unicos, legados);
        } else {
            writerSupport.writeAll(tuples, unicos, legados);
        }
        this.afterWrite();
    }

    protected void beforeWrite(List<TupleLink<S, U>> tuples, List<S> unicos, List<Replicable<S, U>> legados) {
        this.log.debug("Before Write - tuples: {} unicos: {} legados: {}", new Object[]{tuples.size(), unicos.size(), legados.size()});
    }

    protected void afterWrite() {
        this.log.debug("After write");
    }

    protected boolean throwExceptionOnNotExistsInLegado() {
        return true;
    }

    private void internalReplicateUnico(List<TupleLink<S, U>> tuples, List<S> unicos, Replicable<S, U> legado, Class<S> type, Map<String, List<TupleLink<S, U>>> mergeTuple) {
        Replicator replicator = this.getReplicatorForClass(legado.getClass());
        EloDomain unicoReplicate = null;
        unicoReplicate = legado.getIdUnico() == null || this.alwaysCreateNew() ? (EloDomain)BeanUtils.instantiateClass(type) : (EloDomain)this.em.find(type, (Object)legado.getIdUnico());
        unicoReplicate = replicator.to(legado, unicoReplicate);
        unicoReplicate.setSourceClass(legado.getClass().getSimpleName());
        List listOftuples = mergeTuple.getOrDefault(unicoReplicate.hashString(), new ArrayList());
        EloDomain unico = null;
        TupleLink tupleLinkUsed = null;
        for (TupleLink tupleLink : listOftuples) {
            if (tupleLink.isReplicableClassUsed(legado.getClass())) continue;
            unico = tupleLink.getUnico();
            tupleLink.addUsedClass(legado.getClass());
            tupleLinkUsed = tupleLink;
            break;
        }
        if (unico == null) {
            unico = unicoReplicate;
            if (legado.getIdUnico() != null) {
                unico.setId(legado.getIdUnico());
            }
            this.log.trace("Replicating from Legado hash[" + unicoReplicate.hashString() + "] " + String.valueOf(legado) + " to Unico " + String.valueOf(unico));
            unicos.add(unico);
            if (unico.isNew() && !this.chunked) {
                this.attrTemporaryId(unico);
                this.unicosTemporaryId.add(unico);
            }
        } else {
            this.log.trace("Found unico hash[" + unicoReplicate.hashString() + "] " + String.valueOf(unico) + " for legado " + String.valueOf(legado));
            unico = replicator.merge(unico, unicoReplicate);
        }
        TupleLink newTuple = new TupleLink(unico, legado, tupleLinkUsed);
        tuples.add(newTuple);
        listOftuples.add(newTuple);
        mergeTuple.put(unico.hashString(), listOftuples);
    }

    protected boolean alwaysCreateNew() {
        return true;
    }

    private void attrTemporaryId(S unico) {
        Object id = null;
        Class classId = ReflectionUtils.getClassParameterizedType(unico.getClass());
        if (classId.isAssignableFrom(Long.class)) {
            id = (long)(-(this.unicosTemporaryId.size() + 1));
        } else if (classId.isAssignableFrom(String.class)) {
            id = UUID.randomUUID().toString();
        }
        unico.setId((Serializable)id);
    }

    private Replicator<S, U, Replicable<S, U>> getReplicatorForClass(Class<? extends Replicable> classType) {
        for (Replicator replicator : this.replicators) {
            if (!replicator.getReplicableType().equals(classType)) continue;
            return replicator;
        }
        throw new ReplicatorNotFound(classType);
    }

    public void onReplicateLegado(Replicable<S, U> legadoSource, Replicable<S, U> newLegado) {
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    @AfterStep
    public ExitStatus afterStep(StepExecution stepExecution) {
        if (stepExecution.getExecutionContext().getString("FINISH_READ", "false").equals("true") && stepExecution.getStatus().equals((Object)BatchStatus.COMPLETED)) {
            this.beforeFinish();
            try {
                this.validatorWriter.validate(ReflectionUtils.getClassParameterizedType(this.getClass()), this.getReplicableClasses(), this.throwExceptionOnNotExistsInLegado());
            }
            catch (IllegalStateException e) {
                stepExecution.setExitStatus(ExitStatus.FAILED.addExitDescription((Throwable)e));
                stepExecution.setStatus(BatchStatus.FAILED);
                this.log.error("validation", (Throwable)e);
            }
        }
        return stepExecution.getExitStatus();
    }

    protected void beforeFinish() {
        this.log.debug("Before Finish");
    }

    private Set<Class<? extends Replicable<S, U>>> getReplicableClasses() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Replicator replicator : this.replicators) {
            builder.add((Object)replicator.getReplicableType());
        }
        return builder.build();
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public boolean allowReplicateFor(Class<?> source, Class<?> target) {
        return true;
    }

    public BatchProperties getBatchProperties() {
        return this.batchProperties;
    }

    public Logger getLog() {
        return this.log;
    }
}

