/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.step;

import br.com.elotech.di.batch.job.BatchProgressReader;
import br.com.elotech.di.batch.job.ProgressListener;
import br.com.elotech.di.batch.job.StepListener;
import br.com.elotech.di.batch.reader.ItemReaderAgencia;
import br.com.elotech.di.batch.reader.ItemReaderBairro;
import br.com.elotech.di.batch.reader.ItemReaderBanco;
import br.com.elotech.di.batch.reader.ItemReaderCidade;
import br.com.elotech.di.batch.reader.ItemReaderCnae;
import br.com.elotech.di.batch.reader.ItemReaderDocumento;
import br.com.elotech.di.batch.reader.ItemReaderEntidade;
import br.com.elotech.di.batch.reader.ItemReaderLeiAto;
import br.com.elotech.di.batch.reader.ItemReaderLogradouro;
import br.com.elotech.di.batch.reader.ItemReaderModulo;
import br.com.elotech.di.batch.reader.ItemReaderPais;
import br.com.elotech.di.batch.reader.ItemReaderPessoa;
import br.com.elotech.di.batch.reader.ItemReaderRamoAtividade;
import br.com.elotech.di.batch.reader.ItemReaderSocioPessoa;
import br.com.elotech.di.batch.reader.ItemReaderTipoLogradouro;
import br.com.elotech.di.batch.reader.ItemReaderUF;
import br.com.elotech.di.batch.reader.ItemReaderUsuario;
import br.com.elotech.di.batch.reader.ItemReaderVeiculoPublicacao;
import br.com.elotech.di.batch.writer.ItemWriterAgencia;
import br.com.elotech.di.batch.writer.ItemWriterBairro;
import br.com.elotech.di.batch.writer.ItemWriterBanco;
import br.com.elotech.di.batch.writer.ItemWriterCidade;
import br.com.elotech.di.batch.writer.ItemWriterCnae;
import br.com.elotech.di.batch.writer.ItemWriterDocumento;
import br.com.elotech.di.batch.writer.ItemWriterEntidade;
import br.com.elotech.di.batch.writer.ItemWriterLeiAto;
import br.com.elotech.di.batch.writer.ItemWriterLeiAtoPublicacao;
import br.com.elotech.di.batch.writer.ItemWriterLogradouro;
import br.com.elotech.di.batch.writer.ItemWriterModulo;
import br.com.elotech.di.batch.writer.ItemWriterPais;
import br.com.elotech.di.batch.writer.ItemWriterPessoa;
import br.com.elotech.di.batch.writer.ItemWriterRamoAtividade;
import br.com.elotech.di.batch.writer.ItemWriterSocioPessoa;
import br.com.elotech.di.batch.writer.ItemWriterTipoLogradouro;
import br.com.elotech.di.batch.writer.ItemWriterUF;
import br.com.elotech.di.batch.writer.ItemWriterUsuario;
import br.com.elotech.di.batch.writer.ItemWriterVeiculoPublicacao;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.replicate.support.Replicable;
import com.google.common.eventbus.EventBus;
import java.io.Serializable;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;

@Configuration
public class BatchConfigurationStep {
    public static final String STEP_PAIS = "Pais";
    public static final String STEP_UF = "Unidade Federa\u00e7\u00e3o";
    public static final String STEP_TIPO_LOGRADOURO = "Tipo Logradouro";
    public static final String STEP_CIDADE = "Cidade";
    public static final String STEP_LOGRADOURO = "Logradouro";
    public static final String STEP_BAIRRO = "Bairro";
    public static final String STEP_PESSOA = "Pessoa";
    public static final String STEP_SOCIO_PESSOA = "S\u00f3cio Pessoa";
    public static final String STEP_BANCO = "Banco";
    public static final String STEP_AGENCIA = "Agencia";
    public static final String STEP_DOCUMENTO = "Documento";
    public static final String STEP_RAMOATIVIDADE = "RamoAtividade";
    public static final String STEP_ENTIDADE = "Entidade";
    public static final String STEP_CNAE = "Cnae";
    public static final String STEP_LEIATO = "Lei Ato";
    public static final String STEP_VEICULOPUBLICACAO = "Ve\u00edculo Publica\u00e7\u00e3o";
    public static final String STEP_LEIATOPUBLICACAO = "Lei Ato Publica\u00e7\u00e3o";
    public static final String STEP_MODULO = "M\u00f3dulo";
    public static final String STEP_USUARIO = "Usu\u00e1rio";
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private EventBus eventBus;

    protected <S extends EloDomain<U>, U extends Serializable> Step createStep(String name, ItemReader<Replicable<S, U>> reader, ItemWriter<Replicable<S, U>> writer) {
        return this.createStep(name, Integer.MAX_VALUE, reader, writer);
    }

    private <S extends EloDomain<U>, U extends Serializable> Step createStep(String name, int chunkSize, ItemReader<Replicable<S, U>> reader, ItemWriter<Replicable<S, U>> writer) {
        return this.createStepBuilder(name, chunkSize, reader, writer).build();
    }

    private <S extends EloDomain<U>, U extends Serializable> AbstractTaskletStepBuilder<SimpleStepBuilder<Replicable<S, U>, Replicable<S, U>>> createStepBuilder(String name, int chunkSize, ItemReader<Replicable<S, U>> reader, ItemWriter<Replicable<S, U>> writer) {
        StepListener listener = new StepListener(this.getClass().getPackage().getName() + "." + name, this.eventBus);
        return (AbstractTaskletStepBuilder)this.stepBuilderFactory.get(name).chunk(chunkSize).reader(reader).writer(writer).listener((ItemReadListener)listener).listener((ItemWriteListener)listener).listener((StepExecutionListener)listener);
    }

    @Bean
    public Step getStepJoinPais(ItemReaderPais reader, ItemWriterPais writer) {
        return this.createStep(STEP_PAIS, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepJoinUF(ItemReaderUF reader, ItemWriterUF writer) {
        return this.createStep(STEP_UF, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepJoinTipoLogradouro(ItemReaderTipoLogradouro reader, ItemWriterTipoLogradouro writer) {
        return this.createStep(STEP_TIPO_LOGRADOURO, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepJoinCidade(ItemReaderCidade reader, ItemWriterCidade writer) {
        return this.createStep(STEP_CIDADE, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepJoinLogradouro(ItemReaderLogradouro reader, ItemWriterLogradouro writer) {
        return this.createStep(STEP_LOGRADOURO, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepJoinBairro(ItemReaderBairro reader, ItemWriterBairro writer) {
        return this.createStep(STEP_BAIRRO, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    @Primary
    public TaskExecutor taskExecutor() {
        return new SimpleAsyncTaskExecutor("BatchTaskExecutorSimpleAsync");
    }

    @Bean(name={"getStepJoinPessoa"})
    public Step getStepJoinPessoaAsync(ItemReaderPessoa reader, ItemWriterPessoa writer, TaskExecutor taskExecutor) {
        StepListener listener = new StepListener(this.getClass().getPackage().getName() + ".Pessoa", this.eventBus);
        ProgressListener progressListener = new ProgressListener(this.getClass().getPackage().getName() + ".Pessoa", this.eventBus, (BatchProgressReader)reader);
        writer.setChunked(true);
        return ((AbstractTaskletStepBuilder)((SimpleStepBuilder)((AbstractTaskletStepBuilder)((SimpleStepBuilder)this.stepBuilderFactory.get(STEP_PESSOA).chunk(500).reader((ItemReader)reader).writer((ItemWriter)writer).taskExecutor(taskExecutor).listener((Object)listener)).listener((ItemWriteListener)listener).listener((StepExecutionListener)listener)).listener((Object)progressListener)).listener((StepExecutionListener)progressListener)).build();
    }

    @Bean
    public Step getStepSocioPessoa(ItemReaderSocioPessoa reader, ItemWriterSocioPessoa writer, TaskExecutor taskExecutor) {
        ProgressListener progressListener = new ProgressListener(this.getClass().getPackage().getName() + ".Pessoa", this.eventBus, (BatchProgressReader)reader);
        return ((SimpleStepBuilder)((AbstractTaskletStepBuilder)this.createStepBuilder(STEP_SOCIO_PESSOA, 500, (ItemReader)reader, (ItemWriter)writer).taskExecutor(taskExecutor).listener((StepExecutionListener)progressListener)).listener((Object)progressListener)).build();
    }

    @Bean
    public Step getStepJoinDocumento(ItemReaderDocumento reader, ItemWriterDocumento writer) {
        return this.createStep(STEP_DOCUMENTO, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepJoinBanco(ItemReaderBanco reader, ItemWriterBanco writer) {
        return this.createStep(STEP_BANCO, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepJoinAgencia(ItemReaderAgencia reader, ItemWriterAgencia writer) {
        return this.createStep(STEP_AGENCIA, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepRamoAtividade(ItemReaderRamoAtividade reader, ItemWriterRamoAtividade writer) {
        return this.createStep(STEP_RAMOATIVIDADE, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepCnae(ItemReaderCnae reader, ItemWriterCnae writer) {
        return this.createStep(STEP_CNAE, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepEntidade(ItemReaderEntidade reader, ItemWriterEntidade writer) {
        return this.createStep(STEP_ENTIDADE, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepLeiAto(ItemReaderLeiAto reader, ItemWriterLeiAto writer) {
        return this.createStep(STEP_LEIATO, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepVeiculoPublicacao(ItemReaderVeiculoPublicacao reader, ItemWriterVeiculoPublicacao writer) {
        return this.createStep(STEP_VEICULOPUBLICACAO, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepLeiAtoPublicacao(ItemReaderLeiAto reader, ItemWriterLeiAtoPublicacao writer) {
        return this.createStep(STEP_LEIATOPUBLICACAO, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepModulo(ItemReaderModulo reader, ItemWriterModulo writer) {
        return this.createStep(STEP_MODULO, (ItemReader)reader, (ItemWriter)writer);
    }

    @Bean
    public Step getStepUsuario(ItemReaderUsuario reader, ItemWriterUsuario writer) {
        return this.createStep(STEP_USUARIO, (ItemReader)reader, (ItemWriter)writer);
    }
}

