/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.reader;

import br.com.elotech.di.batch.job.BatchProgressReader;
import br.com.elotech.di.batch.reader.CountingItemReader;
import br.com.elotech.di.batch.reader.CountingJpaItemReader;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.replicate.support.Replicable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractCompositeItemReader<S extends EloDomain<U>, U extends Serializable>
implements ItemStreamReader<Replicable<S, U>>,
InitializingBean,
BatchProgressReader {
    public static final String FINISH_READ = "FINISH_READ";
    private static final int DEFAULT_PAGE_SIZE = 500;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    @PersistenceUnit
    private EntityManagerFactory emf;
    private final List<CountingJpaItemReader<? extends Replicable<S, U>>> readers = new ArrayList();
    private StepExecution stepExecution;

    private void registerReader(Class<? extends Replicable<S, U>> type, int pageSize, String hql, String countSql) {
        CountingJpaItemReader itemReader = new CountingJpaItemReader();
        itemReader.setEntityManagerFactory(this.emf);
        itemReader.setPageSize(pageSize);
        itemReader.setTransacted(false);
        itemReader.setSaveState(false);
        if (hql == null) {
            itemReader.setQueryString(" from " + type.getSimpleName());
            itemReader.setQueryCount("select count(*) from " + type.getSimpleName());
        } else {
            itemReader.setQueryString(hql);
            itemReader.setQueryCount(countSql);
        }
        itemReader.setName(type.getName());
        this.readers.add(itemReader);
    }

    public void registerReaderUnlimitedPage(Class<? extends Replicable<S, U>> type) {
        this.registerReader(type, Integer.MAX_VALUE, null, null);
    }

    public void registerReaderHql(Class<? extends Replicable<S, U>> type, String hql, String countSql) {
        this.registerReader(type, 500, hql, countSql);
    }

    public abstract void registerReaders();

    public Replicable<S, U> read() {
        for (CountingJpaItemReader itemStreamReader : this.readers) {
            try {
                Replicable objectRead = (Replicable)itemStreamReader.read();
                while (objectRead != null && !this.accept(objectRead)) {
                    objectRead = (Replicable)itemStreamReader.read();
                }
                if (objectRead == null || !this.accept(objectRead)) continue;
                return objectRead;
            }
            catch (Exception ex) {
                this.log.error("Erro lendo dados com Item Reader: " + itemStreamReader.getName(), (Throwable)ex);
                throw ex;
            }
        }
        if (this.stepExecution != null) {
            this.stepExecution.getExecutionContext().put(FINISH_READ, (Object)"true");
        }
        return null;
    }

    protected boolean accept(Replicable<S, U> legado) {
        return true;
    }

    public void open(ExecutionContext executionContext) {
        for (ItemStreamReader itemStreamReader : this.readers) {
            itemStreamReader.open(executionContext);
        }
    }

    public void update(ExecutionContext executionContext) {
        for (ItemStreamReader itemStreamReader : this.readers) {
            itemStreamReader.update(executionContext);
        }
    }

    public void close() {
        for (ItemStreamReader itemStreamReader : this.readers) {
            itemStreamReader.close();
        }
    }

    public void afterPropertiesSet() {
        this.registerReaders();
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.stepExecution.getExecutionContext().put(FINISH_READ, (Object)"false");
    }

    public Long getCount() {
        long totalCount = 0L;
        for (CountingItemReader reader : this.readers) {
            totalCount += reader.count();
        }
        return totalCount;
    }

    public int getTotalRecords() {
        return this.getCount().intValue();
    }
}

