/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.job.arquivo;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.core.utils.FileUtils;
import java.util.logging.Logger;
import lombok.Generated;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class MigrarArquivoBeforeAndAfterListener
implements StepExecutionListener {
    @Generated
    private static final Logger log = Logger.getLogger(MigrarArquivoBeforeAndAfterListener.class.getName());
    private static final String PREPARA_MIGRACAO_ELOARQUIVO_OXY_PROCESSOS = "sql/prepara-migracao-arquivos-OXY-PROCESSOS.sql";
    private static final String FINALIZA_MIGRACAO_ELOARQUIVO_OXY_PROCESSOS = "sql/finaliza-migracao-arquivos-OXY-PROCESSOS.sql";
    private final JdbcTemplate jdbcTemplate;
    private final DBConfigProperties dbConfigProperties;

    public void beforeStep(StepExecution stepExecution) {
        this.executaSQL(PREPARA_MIGRACAO_ELOARQUIVO_OXY_PROCESSOS);
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        this.executaSQL(FINALIZA_MIGRACAO_ELOARQUIVO_OXY_PROCESSOS);
        return stepExecution.getExitStatus();
    }

    private void executaSQL(String scriptName) {
        String sql = FileUtils.readResourceAsString((String)scriptName).replace("${eloarquivo}", this.dbConfigProperties.getEloarquivo().getSchema()).replace("${protocolo}", this.dbConfigProperties.getProtocolo().getSchema());
        log.info("affects: " + this.jdbcTemplate.update(sql));
    }

    @Generated
    public MigrarArquivoBeforeAndAfterListener(JdbcTemplate jdbcTemplate, DBConfigProperties dbConfigProperties) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbConfigProperties = dbConfigProperties;
    }
}

