/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.job.arquivo;

import br.com.elotech.di.batch.job.BatchProgressReader;
import br.com.elotech.di.config.BatchProperties;
import br.com.elotech.di.domain.dto.MigrarArquivoDTO;
import java.util.Objects;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.springframework.batch.item.database.JdbcPagingItemReader;
import org.springframework.batch.item.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.batch.support.DatabaseType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class MigrarArquivoBatchReader
extends JdbcPagingItemReader<MigrarArquivoDTO>
implements BatchProgressReader {
    public static final String WHERE_CLAUSE = "WHERE A.MODULO IS NOT NULL                AND (A.MIGRADO = 'N' OR A.MIGRADO IS NULL)                AND A.FULLPATH IS NULL";
    private final String eloArquivoSchema;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public MigrarArquivoBatchReader(@Value(value="${spring.liquibase.parameters.db.eloarquivo.schema}") String eloArquivo, @Value(value="${spring.jpa.database:}") String database, DataSource dataSource, BatchProperties batchProperties) {
        this.eloArquivoSchema = eloArquivo;
        this.setFetchSize(batchProperties.getMigrarArquivo().getFetchSize());
        this.setName("Migrar_Arquivos");
        this.setDataSource(dataSource);
        this.setRowMapper((rs, rowNum) -> MigrarArquivoDTO.builder().arquivoId(Long.valueOf(rs.getLong("id"))).build());
        this.setQueryProvider(Objects.requireNonNull(this.queryProvider(this.eloArquivoSchema, database, dataSource).getObject()));
    }

    private SqlPagingQueryProviderFactoryBean queryProvider(String eloArquivoSchema, String database, DataSource dataSource) {
        SqlPagingQueryProviderFactoryBean provider = new SqlPagingQueryProviderFactoryBean();
        provider.setDataSource(dataSource);
        provider.setSelectClause("SELECT ID ");
        provider.setFromClause(String.format("FROM %s.ARQUIVO A ", eloArquivoSchema));
        provider.setWhereClause(WHERE_CLAUSE);
        provider.setSortKey("ID");
        if (!StringUtils.isEmpty((String)database)) {
            provider.setDatabaseType(this.getDatabaseType(database));
        }
        return provider;
    }

    public String getDatabaseType(String database) {
        return Stream.of(DatabaseType.values()).filter(f -> f.getProductName().equalsIgnoreCase(database)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Database type %s n\u00e3o encontrado.", database))).toString();
    }

    public int getTotalRecords() {
        String sql = String.format("SELECT COUNT(*) AS TOTAL FROM %s.ARQUIVO A %s", this.eloArquivoSchema, WHERE_CLAUSE);
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
    }
}

