/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.job;

import br.com.elotech.di.event.JobProgressEvent;
import br.com.elotech.di.event.JobStatusEvent;
import com.google.common.eventbus.EventBus;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.listener.ItemListenerSupport;

public class StepListener<I, O>
extends ItemListenerSupport<I, O>
implements StepExecutionListener {
    private final Logger log;
    private final EventBus eventBus;

    public StepListener(String name, EventBus eventBus) {
        this.log = LoggerFactory.getLogger((String)name);
        this.eventBus = eventBus;
        this.eventBus.register((Object)this);
    }

    public void onReadError(Exception ex) {
        this.log.error("Read Error: ", (Throwable)ex);
    }

    public void onWriteError(Exception ex, List<? extends O> item) {
        this.log.error("Write Error: ", (Throwable)ex);
    }

    public void beforeStep(StepExecution stepExecution) {
        this.eventBus.post((Object)new JobStatusEvent(stepExecution.getJobExecution().getStatus().name()));
        this.eventBus.post((Object)new JobProgressEvent(stepExecution.getJobExecution().getJobInstance().getJobName(), stepExecution.getStepName(), 0));
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        this.eventBus.post((Object)new JobStatusEvent(stepExecution.getJobExecution().getStatus().name()));
        return stepExecution.getExitStatus();
    }
}

