/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.job;

import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.di.batch.job.BatchProgressReader;
import br.com.elotech.di.event.JobProgressEvent;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;

public class ProgressListener<T>
implements StepExecutionListener,
ItemWriteListener<T> {
    private static final int PLACES = 3;
    private static final double CEM = 100.0;
    private AtomicDouble lastPercentageComplete;
    private AtomicLong currentItemCount;
    private double totalItemCount;
    private String stepName;
    private String jobName;
    private final Logger log;
    private final EventBus eventBus;
    private final BatchProgressReader reader;

    public ProgressListener(String name, EventBus eventBus, BatchProgressReader reader) {
        this.log = LoggerFactory.getLogger((String)name);
        this.eventBus = eventBus;
        this.reader = reader;
        this.eventBus.register((Object)this);
    }

    public void beforeStep(StepExecution stepExecution) {
        this.totalItemCount = this.reader.getTotalRecords();
        this.stepName = stepExecution.getStepName();
        this.currentItemCount = new AtomicLong();
        this.lastPercentageComplete = new AtomicDouble(0.0);
        this.jobName = stepExecution.getJobExecution().getJobInstance().getJobName();
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return stepExecution.getExitStatus();
    }

    public void afterWrite(List<? extends T> items) {
        this.currentItemCount.addAndGet(items.size());
        double percentageComplete = 0.0;
        if (this.totalItemCount > 0.0) {
            percentageComplete = this.currentItemCount.doubleValue() * 100.0 / this.totalItemCount;
            percentageComplete = NumberUtils.truncate((double)percentageComplete, (int)3);
        }
        this.sentUpdateIfNeeded(percentageComplete);
    }

    private synchronized void sentUpdateIfNeeded(double percentageComplete) {
        if (percentageComplete > this.lastPercentageComplete.get()) {
            this.lastPercentageComplete = new AtomicDouble(percentageComplete);
            this.eventBus.post((Object)new JobProgressEvent(this.jobName, this.stepName, this.lastPercentageComplete.intValue()));
            this.log.info("Post Event: StepName: " + this.stepName + " Percentage:" + this.lastPercentageComplete.intValue());
        }
    }

    public void beforeWrite(List<? extends T> items) {
    }

    public void onWriteError(Exception exception, List<? extends T> items) {
    }
}

