/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.job;

import br.com.elotech.core.utils.ListUtils;
import br.com.elotech.di.batch.job.BatchProgressReader;
import br.com.elotech.di.domain.dto.PessoaDuplicadaDTO;
import br.com.elotech.di.unificacao.PessoasDuplicadasService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class PessoasDuplicadasBatchReader
extends AbstractPagingItemReader<PessoaDuplicadaDTO>
implements BatchProgressReader {
    private static final int MAX_SIZE = 20000;
    @Autowired
    private PessoasDuplicadasService service;
    private List<PessoaDuplicadaDTO> allDuplicates;

    protected void doReadPage() {
        if (this.results == null) {
            this.initAllDuplicates();
            this.results = new ArrayList();
        }
        this.results.clear();
        this.results.addAll(ListUtils.paginate((List)this.allDuplicates, (int)this.getPage(), (int)this.getPageSize()));
    }

    private void initAllDuplicates() {
        if (this.allDuplicates == null) {
            this.allDuplicates = this.service.findDuplicadas((Pageable)PageRequest.of((int)0, (int)20000)).getContent();
        }
    }

    protected void doOpen() {
        super.doOpen();
        this.results = null;
        this.allDuplicates = null;
    }

    protected void doJumpToPage(int itemIndex) {
    }

    public int getTotalRecords() {
        this.initAllDuplicates();
        return this.allDuplicates.size();
    }

    public boolean isNullResults() {
        return this.allDuplicates == null && this.results == null;
    }
}

